/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.fafquery.processor;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetProcessorDBExecBase;
import com.espertech.esper.common.internal.epl.historical.database.core.PollExecStrategyDBQuery;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FireAndForgetProcessorDBExecPrepared
extends FireAndForgetProcessorDBExecBase {
    private static final Logger log = LoggerFactory.getLogger(FireAndForgetProcessorDBExecPrepared.class);

    public FireAndForgetProcessorDBExecPrepared(PollExecStrategyDBQuery poll, ExprEvaluator lookupValuesEval) {
        super(poll, lookupValuesEval);
        poll.start();
    }

    public Collection<EventBean> performQuery(ExprEvaluatorContext exprEvaluatorContext) {
        if (this.poll == null) {
            throw new EPException("Prepared fire-and-forget query is already closed");
        }
        return this.doPoll(exprEvaluatorContext);
    }

    public void close() {
        if (this.poll != null) {
            try {
                this.poll.done();
            }
            catch (Throwable t) {
                log.error("Failed to return database poll resources: " + t.getMessage(), t);
            }
            try {
                this.poll.destroy();
            }
            catch (Throwable t) {
                log.error("Failed to destroy database poll resources: " + t.getMessage(), t);
            }
            this.poll = null;
        }
    }
}

