/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.fafquery.querymethod;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.context.ContextPartitionSelector;
import com.espertech.esper.common.internal.context.mgr.ContextManagementService;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetInstance;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetProcessor;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.EPPreparedQueryResult;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodAssignerSetter;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelect;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectExec;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectExecUtil;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodUtil;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import java.util.ArrayDeque;
import java.util.Collection;

public class FAFQueryMethodSelectExecSomeContextNoJoin
implements FAFQueryMethodSelectExec {
    public static final FAFQueryMethodSelectExec INSTANCE = new FAFQueryMethodSelectExecSomeContextNoJoin();

    private FAFQueryMethodSelectExecSomeContextNoJoin() {
    }

    @Override
    public EPPreparedQueryResult execute(FAFQueryMethodSelect select, ContextPartitionSelector[] contextPartitionSelectors, FAFQueryMethodAssignerSetter assignerSetter, ContextManagementService contextManagementService) {
        FireAndForgetProcessor processor = select.getProcessors()[0];
        ContextPartitionSelector singleSelector = contextPartitionSelectors != null && contextPartitionSelectors.length > 0 ? contextPartitionSelectors[0] : null;
        Collection<Integer> agentInstanceIds = FAFQueryMethodUtil.agentInstanceIds(processor, singleSelector, contextManagementService);
        Collection<EventBean> events = new ArrayDeque<EventBean>();
        AgentInstanceContext agentInstanceContext = null;
        for (int agentInstanceId : agentInstanceIds) {
            FireAndForgetInstance processorInstance = processor.getProcessorInstanceContextById(agentInstanceId);
            if (processorInstance == null) continue;
            agentInstanceContext = processorInstance.getAgentInstanceContext();
            Collection<EventBean> coll = processorInstance.snapshotBestEffort(select.getQueryGraph(), select.getAnnotations());
            events.addAll(coll);
        }
        ResultSetProcessor resultSetProcessor = FAFQueryMethodSelectExecUtil.processorWithAssign(select.getResultSetProcessorFactoryProvider(), agentInstanceContext, assignerSetter, select.getTableAccesses(), select.getSubselects());
        if (select.getWhereClause() != null) {
            events = FAFQueryMethodSelectExecUtil.filtered(events, select.getWhereClause(), agentInstanceContext);
        }
        return FAFQueryMethodSelectExecUtil.processedNonJoin(resultSetProcessor, events, select.getDistinctKeyGetter());
    }

    @Override
    public void releaseTableLocks(FireAndForgetProcessor[] processors) {
        processors[0].getStatementContext().getTableExprEvaluatorContext().releaseAcquiredLocks();
    }
}

