/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.fafquery.querymethod;

import com.espertech.esper.common.client.context.ContextPartitionSelector;
import com.espertech.esper.common.internal.context.mgr.ContextManagementService;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetProcessor;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.EPPreparedQueryResult;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodAssignerSetter;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelect;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodUtil;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQuerySessionUnprepared;
import java.util.concurrent.atomic.AtomicBoolean;

public class FAFQueryMethodSelectSessionUnprepared
implements FAFQuerySessionUnprepared {
    private final FAFQueryMethodSelect select;

    public FAFQueryMethodSelectSessionUnprepared(FAFQueryMethodSelect select) {
        this.select = select;
    }

    @Override
    public EPPreparedQueryResult execute(AtomicBoolean serviceStatusProvider, FAFQueryMethodAssignerSetter assignerSetter, ContextPartitionSelector[] contextPartitionSelectors, ContextManagementService contextManagementService) {
        return FAFQueryMethodSelectSessionUnprepared.executeSelect(this.select, serviceStatusProvider, assignerSetter, contextPartitionSelectors, contextManagementService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static EPPreparedQueryResult executeSelect(FAFQueryMethodSelect select, AtomicBoolean serviceStatusProvider, FAFQueryMethodAssignerSetter assignerSetter, ContextPartitionSelector[] contextPartitionSelectors, ContextManagementService contextManagementService) {
        if (!serviceStatusProvider.get()) {
            throw FAFQueryMethodUtil.runtimeDestroyed();
        }
        FireAndForgetProcessor[] processors = select.getProcessors();
        if (processors.length > 0 && contextPartitionSelectors != null && contextPartitionSelectors.length != processors.length) {
            throw new IllegalArgumentException("The number of context partition selectors does not match the number of named windows or tables in the from-clause");
        }
        try {
            EPPreparedQueryResult ePPreparedQueryResult = select.getSelectExec().execute(select, contextPartitionSelectors, assignerSetter, contextManagementService);
            return ePPreparedQueryResult;
        }
        finally {
            if (select.isHasTableAccess()) {
                select.getSelectExec().releaseTableLocks(processors);
            }
        }
    }
}

