/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.datacache;

import com.espertech.esper.common.client.configuration.common.ConfigurationCommonCache;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonCacheExpiryTime;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonCacheLRU;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.historical.datacache.HistoricalDataCache;
import com.espertech.esper.common.internal.epl.historical.datacache.HistoricalDataCacheExpiringImpl;
import com.espertech.esper.common.internal.epl.historical.datacache.HistoricalDataCacheLRUImpl;
import com.espertech.esper.common.internal.epl.historical.datacache.HistoricalDataCacheNullImpl;

public class HistoricalDataCacheFactory {
    public HistoricalDataCache getDataCache(ConfigurationCommonCache cacheDesc, AgentInstanceContext agentInstanceContext, int streamNum, int scheduleCallbackId) {
        if (cacheDesc == null) {
            return new HistoricalDataCacheNullImpl();
        }
        if (cacheDesc instanceof ConfigurationCommonCacheLRU) {
            ConfigurationCommonCacheLRU lruCache = (ConfigurationCommonCacheLRU)cacheDesc;
            return new HistoricalDataCacheLRUImpl(lruCache.getSize());
        }
        if (cacheDesc instanceof ConfigurationCommonCacheExpiryTime) {
            ConfigurationCommonCacheExpiryTime expCache = (ConfigurationCommonCacheExpiryTime)cacheDesc;
            return this.makeTimeCache(expCache, agentInstanceContext, streamNum, scheduleCallbackId);
        }
        throw new IllegalStateException("Cache implementation class not configured");
    }

    protected HistoricalDataCache makeTimeCache(ConfigurationCommonCacheExpiryTime expCache, AgentInstanceContext agentInstanceContext, int streamNum, int scheduleCallbackId) {
        return new HistoricalDataCacheExpiringImpl(expCache.getMaxAgeSeconds(), expCache.getPurgeIntervalSeconds(), expCache.getCacheReferenceType(), agentInstanceContext, agentInstanceContext.getScheduleBucket().allocateSlot());
    }
}

