/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.indexingstrategy;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.historical.indexingstrategy.PollResultIndexingStrategy;
import com.espertech.esper.common.internal.epl.historical.indexingstrategy.UnindexedEventTableList;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableOrganization;
import com.espertech.esper.common.internal.epl.index.base.EventTableOrganizationType;
import com.espertech.esper.common.internal.epl.index.base.MultiIndexEventTable;
import java.util.List;

public class PollResultIndexingStrategyMulti
implements PollResultIndexingStrategy {
    public static final EPTypeClass EPTYPE = new EPTypeClass(PollResultIndexingStrategyMulti.class);
    private int streamNum;
    private PollResultIndexingStrategy[] indexingStrategies;

    @Override
    public EventTable[] index(List<EventBean> pollResult, boolean isActiveCache, ExprEvaluatorContext exprEvaluatorContext) {
        if (!isActiveCache) {
            return new EventTable[]{new UnindexedEventTableList(pollResult, this.streamNum)};
        }
        EventTable[] tables = new EventTable[this.indexingStrategies.length];
        for (int i = 0; i < this.indexingStrategies.length; ++i) {
            tables[i] = this.indexingStrategies[i].index(pollResult, isActiveCache, exprEvaluatorContext)[0];
        }
        EventTableOrganization organization = new EventTableOrganization(null, false, false, this.streamNum, null, EventTableOrganizationType.MULTIINDEX);
        return new EventTable[]{new MultiIndexEventTable(tables, organization)};
    }

    public void setStreamNum(int streamNum) {
        this.streamNum = streamNum;
    }

    public void setIndexingStrategies(PollResultIndexingStrategy[] indexingStrategies) {
        this.indexingStrategies = indexingStrategies;
    }
}

