/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.indexingstrategy;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableOrganization;
import com.espertech.esper.common.internal.epl.index.base.EventTableOrganizationType;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class UnindexedEventTableList
implements EventTable {
    private List<EventBean> eventSet;
    private int streamNum;

    public UnindexedEventTableList(List<EventBean> eventSet, int streamNum) {
        this.eventSet = eventSet;
        this.streamNum = streamNum;
    }

    @Override
    public void addRemove(EventBean[] newData, EventBean[] oldData, ExprEvaluatorContext exprEvaluatorContext) {
        exprEvaluatorContext.getInstrumentationProvider().qIndexAddRemove(this, newData, oldData);
        if (newData != null) {
            Collections.addAll(this.eventSet, newData);
        }
        if (oldData != null) {
            for (EventBean removeEvent : oldData) {
                this.eventSet.remove(removeEvent);
            }
        }
        exprEvaluatorContext.getInstrumentationProvider().aIndexAddRemove();
    }

    @Override
    public void add(EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        if (events != null) {
            Collections.addAll(this.eventSet, events);
        }
    }

    @Override
    public void remove(EventBean[] events, ExprEvaluatorContext exprEvaluatorContext) {
        if (events != null) {
            for (EventBean removeEvent : events) {
                this.eventSet.remove(removeEvent);
            }
        }
    }

    @Override
    public void add(EventBean event, ExprEvaluatorContext exprEvaluatorContext) {
        this.eventSet.add(event);
    }

    @Override
    public void remove(EventBean event, ExprEvaluatorContext exprEvaluatorContext) {
        this.eventSet.remove(event);
    }

    @Override
    public Iterator<EventBean> iterator() {
        if (this.eventSet == null) {
            return CollectionUtil.NULL_EVENT_ITERATOR;
        }
        return this.eventSet.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.eventSet.isEmpty();
    }

    public String toString() {
        return this.toQueryPlan();
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void clear() {
        this.eventSet.clear();
    }

    @Override
    public void destroy() {
        this.clear();
    }

    @Override
    public Integer getNumberOfEvents() {
        return this.eventSet.size();
    }

    @Override
    public int getNumKeys() {
        return 0;
    }

    @Override
    public Object getIndex() {
        return this.eventSet;
    }

    @Override
    public EventTableOrganization getOrganization() {
        return new EventTableOrganization(null, false, false, this.streamNum, null, EventTableOrganizationType.UNORGANIZED);
    }

    @Override
    public Class getProviderClass() {
        return UnindexedEventTableList.class;
    }
}

