/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.method.core;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlan;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlanner;
import com.espertech.esper.common.internal.compile.stage1.spec.MethodStreamSpec;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodePropOrStreamDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilMethodDesc;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilResolveExceptionHandler;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityResolve;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierAndStreamRefVisitor;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalEventViewableForgeBase;
import com.espertech.esper.common.internal.epl.historical.method.core.HistoricalEventViewableMethodFactory;
import com.espertech.esper.common.internal.epl.historical.method.core.MethodPollingViewableMeta;
import com.espertech.esper.common.internal.epl.historical.method.core.PollExecStrategyPlanner;
import com.espertech.esper.common.internal.epl.historical.method.poll.MethodConversionStrategyForge;
import com.espertech.esper.common.internal.epl.historical.method.poll.MethodTargetStrategyForge;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HistoricalEventViewableMethodForge
extends HistoricalEventViewableForgeBase {
    private final MethodStreamSpec methodStreamSpec;
    private final MethodPollingViewableMeta metadata;
    private MethodTargetStrategyForge target;
    private MethodConversionStrategyForge conversion;

    public HistoricalEventViewableMethodForge(int streamNum, EventType eventType, MethodStreamSpec methodStreamSpec, MethodPollingViewableMeta metadata) {
        super(streamNum, eventType);
        this.methodStreamSpec = methodStreamSpec;
        this.metadata = metadata;
    }

    @Override
    public List<StmtClassForgeableFactory> validate(StreamTypeService typeService, Map<Integer, List<ExprNode>> sqlParameters, StatementRawInfo rawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        ExprValidationContext validationContext = new ExprValidationContextBuilder(typeService, rawInfo, services).withAllowBindingConsumption(true).build();
        ExprNodeIdentifierAndStreamRefVisitor visitor = new ExprNodeIdentifierAndStreamRefVisitor(true);
        final ArrayList<ExprNode> validatedInputParameters = new ArrayList<ExprNode>();
        for (ExprNode exprNode : this.methodStreamSpec.getExpressions()) {
            ExprNode validated = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.METHODINVJOIN, exprNode, validationContext);
            validatedInputParameters.add(validated);
            validated.accept(visitor);
        }
        for (ExprNodePropOrStreamDesc ref : visitor.getRefs()) {
            this.subordinateStreams.add(ref.getStreamNum());
        }
        Method targetMethod = null;
        if (this.metadata.getMethodProviderClass() != null) {
            ExprNodeUtilResolveExceptionHandler handler = new ExprNodeUtilResolveExceptionHandler(){

                @Override
                public ExprValidationException handle(Exception e) {
                    if (HistoricalEventViewableMethodForge.this.methodStreamSpec.getExpressions().size() == 0) {
                        return new ExprValidationException("Method footprint does not match the number or type of expression parameters, expecting no parameters in method: " + e.getMessage());
                    }
                    EPType[] resultTypes = ExprNodeUtilityQuery.getExprResultTypes(validatedInputParameters);
                    return new ExprValidationException("Method footprint does not match the number or type of expression parameters, expecting a method where parameters are typed '" + ClassHelperPrint.getParameterAsString(resultTypes) + "': " + e.getMessage());
                }
            };
            ExprNodeUtilMethodDesc desc = ExprNodeUtilityResolve.resolveMethodAllowWildcardAndStream(this.metadata.getMethodProviderClass().getName(), this.metadata.isStaticMethod() ? null : ClassHelperGenericType.getClassEPType(this.metadata.getMethodProviderClass()), this.methodStreamSpec.getMethodName(), validatedInputParameters, false, null, handler, this.methodStreamSpec.getMethodName(), rawInfo, services);
            this.inputParamEvaluators = desc.getChildForges();
            targetMethod = desc.getReflectionMethod();
        } else {
            this.inputParamEvaluators = ExprNodeUtilityQuery.getForges(ExprNodeUtilityQuery.toArray(validatedInputParameters));
        }
        MultiKeyPlan multiKeyPlan = MultiKeyPlanner.planMultiKey(this.inputParamEvaluators, false, rawInfo, services.getSerdeResolver());
        this.multiKeyClassRef = multiKeyPlan.getClassRef();
        Pair<MethodTargetStrategyForge, MethodConversionStrategyForge> strategies = PollExecStrategyPlanner.plan(this.metadata, targetMethod, this.eventType);
        this.target = strategies.getFirst();
        this.conversion = strategies.getSecond();
        return multiKeyPlan.getMultiKeyForgeables();
    }

    @Override
    public EPTypeClass typeOfImplementation() {
        return HistoricalEventViewableMethodFactory.EPTYPE;
    }

    @Override
    public void codegenSetter(CodegenExpressionRef ref, CodegenMethod method, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        String configName = this.metadata.getConfigurationName(this.methodStreamSpec);
        method.getBlock().exprDotMethod(ref, "setConfigurationName", CodegenExpressionBuilder.constant(configName)).exprDotMethod(ref, "setTargetStrategy", this.target.make(method, symbols, classScope)).exprDotMethod(ref, "setConversionStrategy", this.conversion.make(method, symbols, classScope));
    }
}

