/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.index.advanced.index.quadtree;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoCast;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprForgeConstantType;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeRenderable;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNodeImpl;
import com.espertech.esper.common.internal.epl.index.advanced.index.quadtree.SettingsApplicationDotMethodBase;
import com.espertech.esper.common.internal.epl.spatial.quadtree.core.BoundingBox;
import com.espertech.esper.common.internal.epl.util.EPLExpressionParamType;
import com.espertech.esper.common.internal.epl.util.EPLValidationUtil;

public class SettingsApplicationDotMethodRectangeIntersectsRectangle
extends SettingsApplicationDotMethodBase {
    protected static final String LOOKUP_OPERATION_NAME = "rectangle.intersects(rectangle)";
    public static final String INDEXTYPE_NAME = "mxcifquadtree";

    public SettingsApplicationDotMethodRectangeIntersectsRectangle(ExprDotNodeImpl parent, String lhsName, ExprNode[] lhs, String dotMethodName, String rhsName, ExprNode[] rhs, ExprNode[] indexNamedParameter) {
        super(parent, lhsName, lhs, dotMethodName, rhsName, rhs, indexNamedParameter);
    }

    @Override
    protected ExprForge validateAll(String lhsName, ExprNode[] lhs, String rhsName, ExprNode[] rhs, ExprValidationContext validationContext) throws ExprValidationException {
        EPLValidationUtil.validateParameterNumber(lhsName, "left-hand-side", false, 4, lhs.length);
        EPLValidationUtil.validateParametersTypePredefined(lhs, lhsName, "left-hand-side", EPLExpressionParamType.NUMERIC);
        EPLValidationUtil.validateParameterNumber(rhsName, "right-hand-side", true, 4, rhs.length);
        EPLValidationUtil.validateParametersTypePredefined(rhs, rhsName, "right-hand-side", EPLExpressionParamType.NUMERIC);
        ExprForge meXEval = lhs[0].getForge();
        ExprForge meYEval = lhs[1].getForge();
        ExprForge meWidthEval = lhs[2].getForge();
        ExprForge meHeightEval = lhs[3].getForge();
        ExprForge otherXEval = rhs[0].getForge();
        ExprForge otherYEval = rhs[1].getForge();
        ExprForge otherWidthEval = rhs[2].getForge();
        ExprForge otherHeightEval = rhs[3].getForge();
        return new RectangleIntersectsRectangleForge(this.parent, meXEval, meYEval, meWidthEval, meHeightEval, otherXEval, otherYEval, otherWidthEval, otherHeightEval);
    }

    @Override
    protected String operationName() {
        return LOOKUP_OPERATION_NAME;
    }

    @Override
    protected String indexTypeName() {
        return INDEXTYPE_NAME;
    }

    public static final class RectangleIntersectsRectangleEvaluator
    implements ExprEvaluator {
        private final ExprEvaluator meXEval;
        private final ExprEvaluator meYEval;
        private final ExprEvaluator meWidthEval;
        private final ExprEvaluator meHeightEval;
        private final ExprEvaluator otherXEval;
        private final ExprEvaluator otherYEval;
        private final ExprEvaluator otherWidthEval;
        private final ExprEvaluator otherHeightEval;

        public RectangleIntersectsRectangleEvaluator(ExprEvaluator meXEval, ExprEvaluator meYEval, ExprEvaluator meWidthEval, ExprEvaluator meHeightEval, ExprEvaluator otherXEval, ExprEvaluator otherYEval, ExprEvaluator otherWidthEval, ExprEvaluator otherHeightEval) {
            this.meXEval = meXEval;
            this.meYEval = meYEval;
            this.meWidthEval = meWidthEval;
            this.meHeightEval = meHeightEval;
            this.otherXEval = otherXEval;
            this.otherYEval = otherYEval;
            this.otherWidthEval = otherWidthEval;
            this.otherHeightEval = otherHeightEval;
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            Number meX = (Number)this.meXEval.evaluate(eventsPerStream, isNewData, context);
            if (meX == null) {
                return null;
            }
            Number meY = (Number)this.meYEval.evaluate(eventsPerStream, isNewData, context);
            if (meY == null) {
                return null;
            }
            Number meWidth = (Number)this.meWidthEval.evaluate(eventsPerStream, isNewData, context);
            if (meWidth == null) {
                return null;
            }
            Number meHeight = (Number)this.meHeightEval.evaluate(eventsPerStream, isNewData, context);
            if (meHeight == null) {
                return null;
            }
            Number otherX = (Number)this.otherXEval.evaluate(eventsPerStream, isNewData, context);
            if (otherX == null) {
                return null;
            }
            Number otherY = (Number)this.otherYEval.evaluate(eventsPerStream, isNewData, context);
            if (otherY == null) {
                return null;
            }
            Number otherWidth = (Number)this.otherWidthEval.evaluate(eventsPerStream, isNewData, context);
            if (otherWidth == null) {
                return null;
            }
            Number otherHeight = (Number)this.otherHeightEval.evaluate(eventsPerStream, isNewData, context);
            if (otherHeight == null) {
                return null;
            }
            double x = meX.doubleValue();
            double y = meY.doubleValue();
            double width = meWidth.doubleValue();
            double height = meHeight.doubleValue();
            return BoundingBox.intersectsBoxIncludingEnd(x, y, x + width, y + height, otherX.doubleValue(), otherY.doubleValue(), otherWidth.doubleValue(), otherHeight.doubleValue());
        }

        public static CodegenExpression codegen(RectangleIntersectsRectangleForge forge, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.BOOLEANBOXED.getEPType(), RectangleIntersectsRectangleEvaluator.class, (CodegenScope)codegenClassScope);
            CodegenBlock block = methodNode.getBlock();
            CodegenLegoCast.asDoubleNullReturnNull(block, "meX", forge.meXEval, methodNode, exprSymbol, codegenClassScope);
            CodegenLegoCast.asDoubleNullReturnNull(block, "meY", forge.meYEval, methodNode, exprSymbol, codegenClassScope);
            CodegenLegoCast.asDoubleNullReturnNull(block, "meWidth", forge.meWidthEval, methodNode, exprSymbol, codegenClassScope);
            CodegenLegoCast.asDoubleNullReturnNull(block, "meHeight", forge.meHeightEval, methodNode, exprSymbol, codegenClassScope);
            CodegenLegoCast.asDoubleNullReturnNull(block, "otherX", forge.otherXEval, methodNode, exprSymbol, codegenClassScope);
            CodegenLegoCast.asDoubleNullReturnNull(block, "otherY", forge.otherYEval, methodNode, exprSymbol, codegenClassScope);
            CodegenLegoCast.asDoubleNullReturnNull(block, "otherWidth", forge.otherWidthEval, methodNode, exprSymbol, codegenClassScope);
            CodegenLegoCast.asDoubleNullReturnNull(block, "otherHeight", forge.otherHeightEval, methodNode, exprSymbol, codegenClassScope);
            block.methodReturn(CodegenExpressionBuilder.staticMethod(BoundingBox.class, "intersectsBoxIncludingEnd", CodegenExpressionBuilder.ref("meX"), CodegenExpressionBuilder.ref("meY"), CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("meX"), "+", CodegenExpressionBuilder.ref("meWidth")), CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("meY"), "+", CodegenExpressionBuilder.ref("meHeight")), CodegenExpressionBuilder.ref("otherX"), CodegenExpressionBuilder.ref("otherY"), CodegenExpressionBuilder.ref("otherWidth"), CodegenExpressionBuilder.ref("otherHeight")));
            return CodegenExpressionBuilder.localMethod(methodNode, new CodegenExpression[0]);
        }
    }

    public static final class RectangleIntersectsRectangleForge
    implements ExprForge {
        private final ExprDotNodeImpl parent;
        protected final ExprForge meXEval;
        protected final ExprForge meYEval;
        protected final ExprForge meWidthEval;
        protected final ExprForge meHeightEval;
        protected final ExprForge otherXEval;
        protected final ExprForge otherYEval;
        protected final ExprForge otherWidthEval;
        protected final ExprForge otherHeightEval;

        public RectangleIntersectsRectangleForge(ExprDotNodeImpl parent, ExprForge meXEval, ExprForge meYEval, ExprForge meWidthEval, ExprForge meHeightEval, ExprForge otherXEval, ExprForge otherYEval, ExprForge otherWidthEval, ExprForge otherHeightEval) {
            this.parent = parent;
            this.meXEval = meXEval;
            this.meYEval = meYEval;
            this.meWidthEval = meWidthEval;
            this.meHeightEval = meHeightEval;
            this.otherXEval = otherXEval;
            this.otherYEval = otherYEval;
            this.otherWidthEval = otherWidthEval;
            this.otherHeightEval = otherHeightEval;
        }

        @Override
        public ExprEvaluator getExprEvaluator() {
            return new RectangleIntersectsRectangleEvaluator(this.meXEval.getExprEvaluator(), this.meYEval.getExprEvaluator(), this.meWidthEval.getExprEvaluator(), this.meHeightEval.getExprEvaluator(), this.otherXEval.getExprEvaluator(), this.otherYEval.getExprEvaluator(), this.otherWidthEval.getExprEvaluator(), this.otherHeightEval.getExprEvaluator());
        }

        @Override
        public CodegenExpression evaluateCodegen(EPTypeClass requiredType, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
            return RectangleIntersectsRectangleEvaluator.codegen(this, codegenMethodScope, exprSymbol, codegenClassScope);
        }

        @Override
        public ExprForgeConstantType getForgeConstantType() {
            return ExprForgeConstantType.NONCONST;
        }

        @Override
        public EPTypeClass getEvaluationType() {
            return EPTypePremade.BOOLEANBOXED.getEPType();
        }

        @Override
        public ExprNodeRenderable getForgeRenderable() {
            return this.parent;
        }
    }
}

