/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.index.advanced.index.quadtree;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.advanced.index.quadtree.EventTableQuadTree;
import com.espertech.esper.common.internal.epl.index.advanced.index.quadtree.SubordTableLookupStrategyFactoryQuadTree;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.common.internal.epl.lookup.SubordTableLookupStrategy;
import java.util.Collection;

public class SubordTableLookupStrategyQuadTreeBase {
    protected final EventTableQuadTree index;
    private final SubordTableLookupStrategyFactoryQuadTree factory;

    public SubordTableLookupStrategyQuadTreeBase(EventTableQuadTree index, SubordTableLookupStrategyFactoryQuadTree factory) {
        this.index = index;
        this.factory = factory;
    }

    protected Collection<EventBean> lookupInternal(EventBean[] events, ExprEvaluatorContext context, EventTableQuadTree index, SubordTableLookupStrategy strategy) {
        double x = this.eval(this.factory.getX(), events, context, "x");
        double y = this.eval(this.factory.getY(), events, context, "y");
        double width = this.eval(this.factory.getWidth(), events, context, "width");
        double height = this.eval(this.factory.getHeight(), events, context, "height");
        if (context.getInstrumentationProvider().activated()) {
            context.getInstrumentationProvider().qIndexSubordLookup(strategy, index, null);
            Collection<EventBean> result = this.index.queryRange(x, y, width, height);
            context.getInstrumentationProvider().aIndexSubordLookup(result, null);
            return result;
        }
        return this.index.queryRange(x, y, width, height);
    }

    public String toQueryPlan() {
        return this.getClass().getSimpleName();
    }

    public LookupStrategyDesc getStrategyDesc() {
        return this.factory.getLookupStrategyDesc();
    }

    private double eval(ExprEvaluator eval, EventBean[] events, ExprEvaluatorContext context, String name) {
        Number number = (Number)eval.evaluate(events, true, context);
        if (number == null) {
            throw new EPException("Invalid null value for '" + name + "'");
        }
        return number.doubleValue();
    }
}

