/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.index.sorted;

import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableFactory;
import com.espertech.esper.common.internal.epl.index.base.EventTableOrganization;
import com.espertech.esper.common.internal.epl.index.base.EventTableOrganizationType;
import com.espertech.esper.common.internal.epl.index.sorted.PropertySortedEventTable;
import com.espertech.esper.common.internal.epl.index.sorted.PropertySortedEventTableImpl;

public class PropertySortedEventTableFactory
implements EventTableFactory {
    protected final int streamNum;
    protected final String propertyName;
    protected final EventPropertyValueGetter propertyGetter;
    protected final EPTypeClass valueType;

    public PropertySortedEventTableFactory(int streamNum, String propertyName, EventPropertyValueGetter propertyGetter, EPTypeClass valueType) {
        this.streamNum = streamNum;
        this.propertyName = propertyName;
        this.propertyGetter = propertyGetter;
        this.valueType = valueType;
    }

    @Override
    public EventTable[] makeEventTables(ExprEvaluatorContext exprEvaluatorContext, Integer subqueryNumber) {
        return new EventTable[]{new PropertySortedEventTableImpl(this)};
    }

    @Override
    public Class getEventTableClass() {
        return PropertySortedEventTable.class;
    }

    @Override
    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " streamNum=" + this.streamNum + " propertyName=" + this.propertyName;
    }

    public int getStreamNum() {
        return this.streamNum;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public EPTypeClass getValueType() {
        return this.valueType;
    }

    protected EventTableOrganization getOrganization() {
        return new EventTableOrganization(null, false, false, this.streamNum, new String[]{this.propertyName}, EventTableOrganizationType.BTREE);
    }
}

