/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.assemble;

import com.espertech.esper.common.internal.epl.join.assemble.BaseAssemblyNodeFactory;
import com.espertech.esper.common.internal.epl.join.assemble.BranchOptionalAssemblyNodeFactory;
import com.espertech.esper.common.internal.epl.join.assemble.BranchRequiredAssemblyNodeFactory;
import com.espertech.esper.common.internal.epl.join.assemble.CartesianProdAssemblyNodeFactory;
import com.espertech.esper.common.internal.epl.join.assemble.LeafAssemblyNodeFactory;
import com.espertech.esper.common.internal.epl.join.assemble.RootCartProdAssemblyNodeFactory;
import com.espertech.esper.common.internal.epl.join.assemble.RootOptionalAssemblyNodeFactory;
import com.espertech.esper.common.internal.epl.join.assemble.RootRequiredAssemblyNodeFactory;
import com.espertech.esper.common.internal.epl.join.queryplanbuild.NStreamOuterQueryPlanBuilder;
import com.espertech.esper.common.internal.util.IndentWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssemblyStrategyTreeBuilder {
    private static final Logger log = LoggerFactory.getLogger(AssemblyStrategyTreeBuilder.class);

    public static BaseAssemblyNodeFactory build(int rootStream, Map<Integer, int[]> streamsJoinedPerStream, boolean[] isRequiredPerStream) {
        if (streamsJoinedPerStream.size() < 3) {
            throw new IllegalArgumentException("Not a 3-way join");
        }
        if (rootStream < 0 || rootStream >= streamsJoinedPerStream.size()) {
            throw new IllegalArgumentException("Invalid root stream");
        }
        if (isRequiredPerStream.length != streamsJoinedPerStream.size()) {
            throw new IllegalArgumentException("Arrays not matching up");
        }
        NStreamOuterQueryPlanBuilder.verifyJoinedPerStream(rootStream, streamsJoinedPerStream);
        if (log.isDebugEnabled()) {
            log.debug(".build Building node for root stream " + rootStream + " streamsJoinedPerStream=" + NStreamOuterQueryPlanBuilder.print(streamsJoinedPerStream) + " isRequiredPerStream=" + Arrays.toString(isRequiredPerStream));
        }
        BaseAssemblyNodeFactory topNode = AssemblyStrategyTreeBuilder.createNode(true, rootStream, streamsJoinedPerStream.size(), streamsJoinedPerStream.get(rootStream), isRequiredPerStream);
        AssemblyStrategyTreeBuilder.recursiveBuild(rootStream, topNode, streamsJoinedPerStream, isRequiredPerStream);
        if (log.isDebugEnabled()) {
            StringWriter buf = new StringWriter();
            PrintWriter print = new PrintWriter(buf);
            IndentWriter indentWriter = new IndentWriter(print, 0, 2);
            topNode.printDescendends(indentWriter);
            log.debug(".build Dumping root node for stream " + rootStream + ": \n" + buf.toString());
        }
        return topNode;
    }

    private static void recursiveBuild(int parentStreamNum, BaseAssemblyNodeFactory parentNode, Map<Integer, int[]> streamsJoinedPerStream, boolean[] isRequiredPerStream) {
        int numStreams = streamsJoinedPerStream.size();
        for (int i = 0; i < streamsJoinedPerStream.get(parentStreamNum).length; ++i) {
            int streamJoined = streamsJoinedPerStream.get(parentStreamNum)[i];
            BaseAssemblyNodeFactory childNode = AssemblyStrategyTreeBuilder.createNode(false, streamJoined, numStreams, streamsJoinedPerStream.get(streamJoined), isRequiredPerStream);
            parentNode.addChild(childNode);
            if (streamsJoinedPerStream.get(streamJoined).length <= 0) continue;
            AssemblyStrategyTreeBuilder.recursiveBuild(streamJoined, childNode, streamsJoinedPerStream, isRequiredPerStream);
        }
    }

    private static BaseAssemblyNodeFactory createNode(boolean isRoot, int streamNum, int numStreams, int[] joinedStreams, boolean[] isRequiredPerStream) {
        if (joinedStreams.length == 0) {
            return new LeafAssemblyNodeFactory(streamNum, numStreams);
        }
        if (joinedStreams.length == 1) {
            int joinedStream = joinedStreams[0];
            boolean isRequired = isRequiredPerStream[joinedStream];
            if (isRequired) {
                if (isRoot) {
                    return new RootRequiredAssemblyNodeFactory(streamNum, numStreams);
                }
                return new BranchRequiredAssemblyNodeFactory(streamNum, numStreams);
            }
            if (isRoot) {
                return new RootOptionalAssemblyNodeFactory(streamNum, numStreams);
            }
            return new BranchOptionalAssemblyNodeFactory(streamNum, numStreams);
        }
        boolean allSubStreamsOptional = true;
        for (int i = 0; i < joinedStreams.length; ++i) {
            int stream = joinedStreams[i];
            if (!isRequiredPerStream[stream]) continue;
            allSubStreamsOptional = false;
        }
        if (isRoot) {
            return new RootCartProdAssemblyNodeFactory(streamNum, numStreams, allSubStreamsOptional);
        }
        return new CartesianProdAssemblyNodeFactory(streamNum, numStreams, allSubStreamsOptional);
    }
}

