/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.assemble;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.join.assemble.BaseAssemblyNode;
import com.espertech.esper.common.internal.epl.join.assemble.CartesianUtil;
import com.espertech.esper.common.internal.epl.join.assemble.RootCartProdAssemblyNode;
import com.espertech.esper.common.internal.epl.join.rep.Node;
import com.espertech.esper.common.internal.util.IndentWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CartesianProdAssemblyNode
extends BaseAssemblyNode {
    private final int[] childStreamIndex;
    private final boolean allSubStreamsOptional;
    private List<Node> resultsForStream;
    private int[][] subStreamsNumsPerChild;
    private int[][] combinedSubStreams;
    private Node singleResultNode;
    private EventBean singleResultParentEvent;
    private List<EventBean[]>[] singleResultRowsPerStream;
    private boolean haveChildResults;
    private Map<EventBean, ChildStreamResults> completedEvents;

    public CartesianProdAssemblyNode(int streamNum, int numStreams, boolean allSubStreamsOptional, int[] childStreamIndex) {
        super(streamNum, numStreams);
        this.childStreamIndex = childStreamIndex;
        this.allSubStreamsOptional = allSubStreamsOptional;
    }

    @Override
    public void init(List<Node>[] result) {
        this.resultsForStream = result[this.streamNum];
        this.singleResultNode = null;
        this.singleResultParentEvent = null;
        this.singleResultRowsPerStream = null;
        this.haveChildResults = false;
        if (this.subStreamsNumsPerChild == null) {
            if (this.childNodes.size() < 2) {
                throw new IllegalStateException("Expecting at least 2 child nodes");
            }
            this.subStreamsNumsPerChild = new int[this.childNodes.size()][];
            for (int i = 0; i < this.childNodes.size(); ++i) {
                this.subStreamsNumsPerChild[i] = ((BaseAssemblyNode)this.childNodes.get(i)).getSubstreams();
            }
            this.combinedSubStreams = RootCartProdAssemblyNode.computeCombined(this.subStreamsNumsPerChild);
        }
        if (this.resultsForStream != null) {
            Node node;
            Set<EventBean> nodeEvents;
            int numNodes = this.resultsForStream.size();
            if (numNodes == 1 && (nodeEvents = (node = this.resultsForStream.get(0)).getEvents()).size() == 1) {
                this.singleResultNode = node;
                this.singleResultParentEvent = nodeEvents.iterator().next();
                this.singleResultRowsPerStream = new LinkedList[this.childNodes.size()];
            }
            if (this.singleResultNode == null) {
                this.completedEvents = new HashMap<EventBean, ChildStreamResults>();
            }
        } else {
            this.completedEvents = new HashMap<EventBean, ChildStreamResults>();
        }
    }

    @Override
    public void process(List<Node>[] result, Collection<EventBean[]> resultFinalRows, EventBean resultRootEvent) {
        if (this.resultsForStream == null) {
            return;
        }
        if (this.singleResultNode != null) {
            if (!this.haveChildResults) {
                if (this.allSubStreamsOptional) {
                    EventBean[] row = new EventBean[this.numStreams];
                    row[this.streamNum] = this.singleResultParentEvent;
                    this.parentNode.result(row, this.streamNum, this.singleResultNode.getParentEvent(), this.singleResultNode, resultFinalRows, resultRootEvent);
                }
                return;
            }
            this.postCartesian(this.singleResultRowsPerStream, this.singleResultNode, resultFinalRows, resultRootEvent);
            return;
        }
        for (Node node : this.resultsForStream) {
            Set<EventBean> events = node.getEvents();
            for (EventBean theEvent : events) {
                ChildStreamResults results = this.completedEvents.get(theEvent);
                if (results == null) {
                    if (!this.allSubStreamsOptional) continue;
                    EventBean[] row = new EventBean[this.numStreams];
                    row[this.streamNum] = theEvent;
                    this.parentNode.result(row, this.streamNum, node.getParentEvent(), node.getParent(), resultFinalRows, resultRootEvent);
                    continue;
                }
                this.postCartesian(results.getRowsPerStream(), node, resultFinalRows, resultRootEvent);
            }
        }
    }

    private void postCartesian(List<EventBean[]>[] rowsPerStream, Node node, Collection<EventBean[]> resultFinalRows, EventBean resultRootEvent) {
        LinkedList<EventBean[]> result = new LinkedList<EventBean[]>();
        CartesianUtil.computeCartesian(rowsPerStream[0], this.subStreamsNumsPerChild[0], rowsPerStream[1], this.subStreamsNumsPerChild[1], result);
        if (rowsPerStream.length > 2) {
            for (int i = 0; i < this.subStreamsNumsPerChild.length - 2; ++i) {
                LinkedList<EventBean[]> product = new LinkedList<EventBean[]>();
                CartesianUtil.computeCartesian(result, this.combinedSubStreams[i], rowsPerStream[i + 2], this.subStreamsNumsPerChild[i + 2], product);
                result = product;
            }
        }
        for (EventBean[] row : result) {
            this.parentNode.result(row, this.streamNum, node.getParentEvent(), node.getParent(), resultFinalRows, resultRootEvent);
        }
    }

    @Override
    public void result(EventBean[] row, int fromStreamNum, EventBean myEvent, Node myNode, Collection<EventBean[]> resultFinalRows, EventBean resultRootEvent) {
        row[this.streamNum] = myEvent;
        int childStreamArrIndex = this.childStreamIndex[fromStreamNum];
        if (this.singleResultNode != null) {
            List<EventBean[]> streamRows;
            this.haveChildResults = true;
            if (this.singleResultRowsPerStream == null) {
                this.singleResultRowsPerStream = new LinkedList[this.childNodes.size()];
            }
            if ((streamRows = this.singleResultRowsPerStream[childStreamArrIndex]) == null) {
                this.singleResultRowsPerStream[childStreamArrIndex] = streamRows = new LinkedList<EventBean[]>();
            }
            streamRows.add(row);
            return;
        }
        ChildStreamResults childStreamResults = this.completedEvents.get(myEvent);
        if (childStreamResults == null) {
            childStreamResults = new ChildStreamResults(this.childNodes.size());
            this.completedEvents.put(myEvent, childStreamResults);
        }
        childStreamResults.add(childStreamArrIndex, row);
    }

    @Override
    public void print(IndentWriter indentWriter) {
        indentWriter.println("CartesianProdAssemblyNode streamNum=" + this.streamNum);
    }

    public static class ChildStreamResults {
        private List<EventBean[]>[] rowsPerStream;

        public ChildStreamResults(int size) {
            this.rowsPerStream = new LinkedList[size];
        }

        public void add(int fromStreamIndex, EventBean[] row) {
            List<EventBean[]> rows = this.rowsPerStream[fromStreamIndex];
            if (rows == null) {
                this.rowsPerStream[fromStreamIndex] = rows = new LinkedList<EventBean[]>();
            }
            rows.add(row);
        }

        public List<EventBean[]>[] getRowsPerStream() {
            return this.rowsPerStream;
        }
    }
}

