/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.assemble;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.join.assemble.BaseAssemblyNode;
import com.espertech.esper.common.internal.epl.join.assemble.CartesianUtil;
import com.espertech.esper.common.internal.epl.join.rep.Node;
import com.espertech.esper.common.internal.util.IndentWriter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class RootCartProdAssemblyNode
extends BaseAssemblyNode {
    private final int[] childStreamIndex;
    private final List<EventBean[]>[] rowsPerStream;
    private final boolean allSubStreamsOptional;
    private int[][] subStreamsNumsPerChild;
    private int[][] combinedSubStreams;
    private boolean haveChildResults;

    public RootCartProdAssemblyNode(int streamNum, int numStreams, boolean allSubStreamsOptional, int[] childStreamIndex) {
        super(streamNum, numStreams);
        this.allSubStreamsOptional = allSubStreamsOptional;
        this.childStreamIndex = childStreamIndex;
        this.rowsPerStream = new List[numStreams];
    }

    @Override
    public void init(List<Node>[] result) {
        int i;
        if (this.subStreamsNumsPerChild == null) {
            if (this.childNodes.size() < 2) {
                throw new IllegalStateException("Expecting at least 2 child nodes");
            }
            this.subStreamsNumsPerChild = new int[this.childNodes.size()][];
            for (i = 0; i < this.childNodes.size(); ++i) {
                this.subStreamsNumsPerChild[i] = ((BaseAssemblyNode)this.childNodes.get(i)).getSubstreams();
            }
            this.combinedSubStreams = RootCartProdAssemblyNode.computeCombined(this.subStreamsNumsPerChild);
        }
        this.haveChildResults = false;
        for (i = 0; i < this.rowsPerStream.length; ++i) {
            this.rowsPerStream[i] = null;
        }
    }

    @Override
    public void process(List<Node>[] result, Collection<EventBean[]> resultFinalRows, EventBean resultRootEvent) {
        if (!this.haveChildResults && this.allSubStreamsOptional) {
            EventBean[] row = new EventBean[this.numStreams];
            this.parentNode.result(row, this.streamNum, null, null, resultFinalRows, resultRootEvent);
            return;
        }
        this.postCartesian(this.rowsPerStream, resultFinalRows, resultRootEvent);
    }

    @Override
    public void result(EventBean[] row, int fromStreamNum, EventBean myEvent, Node myNode, Collection<EventBean[]> resultFinalRows, EventBean resultRootEvent) {
        this.haveChildResults = true;
        row[this.streamNum] = myEvent;
        int childStreamArrIndex = this.childStreamIndex[fromStreamNum];
        List<EventBean[]> rows = this.rowsPerStream[childStreamArrIndex];
        if (rows == null) {
            this.rowsPerStream[childStreamArrIndex] = rows = new LinkedList<EventBean[]>();
        }
        rows.add(row);
    }

    @Override
    public void print(IndentWriter indentWriter) {
        indentWriter.println("RootCartProdAssemblyNode streamNum=" + this.streamNum);
    }

    private void postCartesian(List<EventBean[]>[] rowsPerStream, Collection<EventBean[]> resultFinalRows, EventBean resultRootEvent) {
        LinkedList<EventBean[]> result = new LinkedList<EventBean[]>();
        CartesianUtil.computeCartesian(rowsPerStream[0], this.subStreamsNumsPerChild[0], rowsPerStream[1], this.subStreamsNumsPerChild[1], result);
        if (rowsPerStream.length > 2) {
            for (int i = 0; i < this.subStreamsNumsPerChild.length - 2; ++i) {
                LinkedList<EventBean[]> product = new LinkedList<EventBean[]>();
                CartesianUtil.computeCartesian(result, this.combinedSubStreams[i], rowsPerStream[i + 2], this.subStreamsNumsPerChild[i + 2], product);
                result = product;
            }
        }
        for (EventBean[] row : result) {
            this.parentNode.result(row, this.streamNum, null, null, resultFinalRows, resultRootEvent);
        }
    }

    protected static int[][] computeCombined(int[][] subStreamsPerChild) {
        if (subStreamsPerChild.length < 3) {
            return null;
        }
        int[][] result = new int[subStreamsPerChild.length - 2][];
        result[0] = RootCartProdAssemblyNode.addSubstreams(subStreamsPerChild[0], subStreamsPerChild[1]);
        for (int i = 0; i < subStreamsPerChild.length - 3; ++i) {
            result[i + 1] = RootCartProdAssemblyNode.addSubstreams(result[i], subStreamsPerChild[i + 2]);
        }
        return result;
    }

    private static int[] addSubstreams(int[] arrayOne, int[] arrayTwo) {
        int i;
        int[] result = new int[arrayOne.length + arrayTwo.length];
        int count = 0;
        for (i = 0; i < arrayOne.length; ++i) {
            result[count] = arrayOne[i];
            ++count;
        }
        for (i = 0; i < arrayTwo.length; ++i) {
            result[count] = arrayTwo[i];
            ++count;
        }
        return result;
    }
}

