/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.base;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.join.base.JoinExecutionStrategy;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposer;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerUtil;
import com.espertech.esper.common.internal.epl.join.base.JoinSetProcessor;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import java.util.Set;

public class JoinExecutionStrategyImpl
implements JoinExecutionStrategy {
    private final JoinSetComposer composer;
    private final ExprEvaluator optionalFilter;
    private final JoinSetProcessor indicator;
    private final ExprEvaluatorContext staticExprEvaluatorContext;

    public JoinExecutionStrategyImpl(JoinSetComposer composer, ExprEvaluator optionalFilter, JoinSetProcessor indicator, ExprEvaluatorContext staticExprEvaluatorContext) {
        this.composer = composer;
        this.optionalFilter = optionalFilter;
        this.indicator = indicator;
        this.staticExprEvaluatorContext = staticExprEvaluatorContext;
    }

    @Override
    public void join(EventBean[][] newDataPerStream, EventBean[][] oldDataPerStream) {
        InstrumentationCommon instrumentationCommon = this.staticExprEvaluatorContext.getInstrumentationProvider();
        instrumentationCommon.qJoinExecStrategy();
        UniformPair<Set<MultiKeyArrayOfKeys<EventBean>>> joinSet = this.composer.join(newDataPerStream, oldDataPerStream, this.staticExprEvaluatorContext);
        instrumentationCommon.aJoinExecStrategy(joinSet);
        if (this.optionalFilter != null) {
            instrumentationCommon.qJoinExecFilter();
            this.processFilter(joinSet.getFirst(), joinSet.getSecond(), this.staticExprEvaluatorContext);
            instrumentationCommon.aJoinExecFilter(joinSet.getFirst(), joinSet.getSecond());
        }
        if (!joinSet.getFirst().isEmpty() || !joinSet.getSecond().isEmpty()) {
            instrumentationCommon.qJoinExecProcess(joinSet);
            this.indicator.process(joinSet.getFirst(), joinSet.getSecond(), this.staticExprEvaluatorContext);
            instrumentationCommon.aJoinExecProcess();
        }
    }

    @Override
    public Set<MultiKeyArrayOfKeys<EventBean>> staticJoin() {
        Set<MultiKeyArrayOfKeys<EventBean>> joinSet = this.composer.staticJoin();
        if (this.optionalFilter != null) {
            this.processFilter(joinSet, null, this.staticExprEvaluatorContext);
        }
        return joinSet;
    }

    private void processFilter(Set<MultiKeyArrayOfKeys<EventBean>> newEvents, Set<MultiKeyArrayOfKeys<EventBean>> oldEvents, ExprEvaluatorContext exprEvaluatorContext) {
        JoinSetComposerUtil.filter(this.optionalFilter, newEvents, true, exprEvaluatorContext);
        if (oldEvents != null) {
            JoinSetComposerUtil.filter(this.optionalFilter, oldEvents, false, exprEvaluatorContext);
        }
    }
}

