/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.base;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableVisitor;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposer;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerUtil;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupIndexReqKey;
import com.espertech.esper.common.internal.epl.join.strategy.QueryStrategy;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class JoinSetComposerImpl
implements JoinSetComposer {
    private final boolean allowInitIndex;
    protected final EventTable[][] repositories;
    protected final QueryStrategy[] queryStrategies;
    private final boolean isPureSelfJoin;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final boolean joinRemoveStream;
    protected Set<MultiKeyArrayOfKeys<EventBean>> oldResults = new LinkedHashSet<MultiKeyArrayOfKeys<EventBean>>();
    protected Set<MultiKeyArrayOfKeys<EventBean>> newResults = new LinkedHashSet<MultiKeyArrayOfKeys<EventBean>>();

    public JoinSetComposerImpl(boolean allowInitIndex, Map<TableLookupIndexReqKey, EventTable>[] repositories, QueryStrategy[] queryStrategies, boolean isPureSelfJoin, ExprEvaluatorContext exprEvaluatorContext, boolean joinRemoveStream) {
        this.allowInitIndex = allowInitIndex;
        this.repositories = JoinSetComposerUtil.toArray(repositories);
        this.queryStrategies = queryStrategies;
        this.isPureSelfJoin = isPureSelfJoin;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.joinRemoveStream = joinRemoveStream;
    }

    @Override
    public boolean allowsInit() {
        return this.allowInitIndex;
    }

    @Override
    public void init(EventBean[][] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        if (!this.allowInitIndex) {
            throw new IllegalStateException("Initialization by events not supported");
        }
        for (int i = 0; i < eventsPerStream.length; ++i) {
            if (eventsPerStream[i] == null) continue;
            for (int j = 0; j < this.repositories[i].length; ++j) {
                this.repositories[i][j].add(eventsPerStream[i], exprEvaluatorContext);
            }
        }
    }

    @Override
    public void destroy() {
        for (int i = 0; i < this.repositories.length; ++i) {
            if (this.repositories[i] == null) continue;
            for (EventTable table : this.repositories[i]) {
                table.destroy();
            }
        }
    }

    @Override
    public UniformPair<Set<MultiKeyArrayOfKeys<EventBean>>> join(EventBean[][] newDataPerStream, EventBean[][] oldDataPerStream, ExprEvaluatorContext exprEvaluatorContext) {
        int i;
        InstrumentationCommon instrumentationCommon = exprEvaluatorContext.getInstrumentationProvider();
        instrumentationCommon.qJoinCompositionWinToWin();
        this.oldResults.clear();
        this.newResults.clear();
        if (this.joinRemoveStream) {
            for (i = 0; i < oldDataPerStream.length; ++i) {
                if (oldDataPerStream[i] == null) continue;
                instrumentationCommon.qJoinCompositionQueryStrategy(false, i, oldDataPerStream[i]);
                this.queryStrategies[i].lookup(oldDataPerStream[i], this.oldResults, exprEvaluatorContext);
                instrumentationCommon.aJoinCompositionQueryStrategy();
            }
        }
        for (int stream = 0; stream < newDataPerStream.length; ++stream) {
            instrumentationCommon.qJoinCompositionStepUpdIndex(stream, newDataPerStream[stream], oldDataPerStream[stream]);
            for (int j = 0; j < this.repositories[stream].length; ++j) {
                this.repositories[stream][j].addRemove(newDataPerStream[stream], oldDataPerStream[stream], exprEvaluatorContext);
            }
            instrumentationCommon.aJoinCompositionStepUpdIndex();
        }
        for (i = 0; i < newDataPerStream.length; ++i) {
            if (newDataPerStream[i] == null) continue;
            instrumentationCommon.qJoinCompositionQueryStrategy(true, i, newDataPerStream[i]);
            this.queryStrategies[i].lookup(newDataPerStream[i], this.newResults, exprEvaluatorContext);
            instrumentationCommon.aJoinCompositionQueryStrategy();
        }
        if (this.isPureSelfJoin) {
            EventTable[][] eventTableArray = this.repositories;
            int n = eventTableArray.length;
            for (int j = 0; j < n; ++j) {
                EventTable[] repository;
                for (EventTable aRepository : repository = eventTableArray[j]) {
                    aRepository.clear();
                }
            }
        }
        instrumentationCommon.aJoinCompositionWinToWin(this.newResults, this.oldResults);
        return new UniformPair<Set<MultiKeyArrayOfKeys<EventBean>>>(this.newResults, this.oldResults);
    }

    protected EventTable[][] getTables() {
        return this.repositories;
    }

    protected QueryStrategy[] getQueryStrategies() {
        return this.queryStrategies;
    }

    @Override
    public Set<MultiKeyArrayOfKeys<EventBean>> staticJoin() {
        LinkedHashSet<MultiKeyArrayOfKeys<EventBean>> result = new LinkedHashSet<MultiKeyArrayOfKeys<EventBean>>();
        EventBean[] lookupEvents = new EventBean[1];
        for (int stream = 0; stream < this.queryStrategies.length; ++stream) {
            if (this.repositories[stream] == null) continue;
            Iterator<EventBean> streamEvents = this.repositories[stream][0].iterator();
            while (streamEvents.hasNext()) {
                lookupEvents[0] = streamEvents.next();
                this.queryStrategies[stream].lookup(lookupEvents, result, this.exprEvaluatorContext);
            }
        }
        return result;
    }

    @Override
    public void accept(EventTableVisitor visitor) {
        visitor.visit(this.repositories);
    }
}

