/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.base;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalDataQueryStrategy;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalEventViewable;
import com.espertech.esper.common.internal.epl.historical.indexingstrategy.PollResultIndexingStrategy;
import com.espertech.esper.common.internal.epl.historical.indexingstrategy.PollResultIndexingStrategyNoIndex;
import com.espertech.esper.common.internal.epl.historical.lookupstrategy.HistoricalIndexLookupStrategy;
import com.espertech.esper.common.internal.epl.historical.lookupstrategy.HistoricalIndexLookupStrategyNoIndex;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerDesc;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerHistoricalImpl;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerPrototypeBase;
import com.espertech.esper.common.internal.epl.join.strategy.QueryStrategy;
import com.espertech.esper.common.internal.view.core.Viewable;

public class JoinSetComposerPrototypeHistorical2Stream
extends JoinSetComposerPrototypeBase {
    public static final EPTypeClass EPTYPE = new EPTypeClass(JoinSetComposerPrototypeHistorical2Stream.class);
    private int polledNum;
    private int streamNum;
    private ExprEvaluator outerJoinEqualsEval;
    private HistoricalIndexLookupStrategy lookupStrategy;
    private PollResultIndexingStrategy indexingStrategy;
    private boolean isAllHistoricalNoSubordinate;
    private boolean[] outerJoinPerStream;

    @Override
    public JoinSetComposerDesc create(Viewable[] streamViews, boolean isFireAndForget, AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        QueryStrategy[] queryStrategies = new QueryStrategy[this.streamTypes.length];
        HistoricalEventViewable viewable = (HistoricalEventViewable)streamViews[this.polledNum];
        queryStrategies[this.streamNum] = new HistoricalDataQueryStrategy(this.streamNum, this.polledNum, viewable, this.outerJoinPerStream[this.streamNum], this.outerJoinEqualsEval, this.lookupStrategy, this.indexingStrategy);
        if (this.isAllHistoricalNoSubordinate) {
            viewable = (HistoricalEventViewable)streamViews[this.streamNum];
            queryStrategies[this.polledNum] = new HistoricalDataQueryStrategy(this.polledNum, this.streamNum, viewable, this.outerJoinPerStream[this.polledNum], this.outerJoinEqualsEval, HistoricalIndexLookupStrategyNoIndex.INSTANCE, PollResultIndexingStrategyNoIndex.INSTANCE);
        }
        boolean allowIndexInit = agentInstanceContext.getEventTableIndexService().allowInitIndex(isRecoveringResilient);
        JoinSetComposerHistoricalImpl composer = new JoinSetComposerHistoricalImpl(allowIndexInit, null, queryStrategies, streamViews, agentInstanceContext);
        return new JoinSetComposerDesc(composer, this.postJoinFilterEvaluator);
    }

    public void setPolledNum(int polledNum) {
        this.polledNum = polledNum;
    }

    public void setStreamNum(int streamNum) {
        this.streamNum = streamNum;
    }

    public void setOuterJoinEqualsEval(ExprEvaluator outerJoinEqualsEval) {
        this.outerJoinEqualsEval = outerJoinEqualsEval;
    }

    public void setLookupStrategy(HistoricalIndexLookupStrategy lookupStrategy) {
        this.lookupStrategy = lookupStrategy;
    }

    public void setIndexingStrategy(PollResultIndexingStrategy indexingStrategy) {
        this.indexingStrategy = indexingStrategy;
    }

    public void setAllHistoricalNoSubordinate(boolean allHistoricalNoSubordinate) {
        this.isAllHistoricalNoSubordinate = allHistoricalNoSubordinate;
    }

    public void setOuterJoinPerStream(boolean[] outerJoinPerStream) {
        this.outerJoinPerStream = outerJoinPerStream;
    }
}

