/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.exec.base;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalEventViewable;
import com.espertech.esper.common.internal.epl.historical.indexingstrategy.PollResultIndexingStrategy;
import com.espertech.esper.common.internal.epl.historical.lookupstrategy.HistoricalIndexLookupStrategy;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.join.strategy.ExecNode;
import com.espertech.esper.common.internal.util.IndentWriter;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoricalDataExecNode
extends ExecNode {
    private static final Logger log = LoggerFactory.getLogger(HistoricalDataExecNode.class);
    private final EventBean[][] lookupRows1Event;
    private final int numStreams;
    private final HistoricalEventViewable historicalEventViewable;
    private final PollResultIndexingStrategy indexingStrategy;
    private final HistoricalIndexLookupStrategy indexLookupStrategy;
    private final int historicalStreamNumber;

    public HistoricalDataExecNode(HistoricalEventViewable historicalEventViewable, PollResultIndexingStrategy indexingStrategy, HistoricalIndexLookupStrategy indexLookupStrategy, int numStreams, int historicalStreamNumber) {
        this.historicalEventViewable = historicalEventViewable;
        this.indexingStrategy = indexingStrategy;
        this.indexLookupStrategy = indexLookupStrategy;
        this.numStreams = numStreams;
        this.historicalStreamNumber = historicalStreamNumber;
        this.lookupRows1Event = new EventBean[1][];
        this.lookupRows1Event[0] = new EventBean[numStreams];
    }

    @Override
    public void process(EventBean lookupEvent, EventBean[] prefillPath, Collection<EventBean[]> result, ExprEvaluatorContext exprEvaluatorContext) {
        EventTable[][] indexPerLookupRow;
        this.lookupRows1Event[0] = prefillPath;
        for (EventTable[] index : indexPerLookupRow = this.historicalEventViewable.poll(this.lookupRows1Event, this.indexingStrategy, exprEvaluatorContext)) {
            Iterator<EventBean> subsetIter = this.indexLookupStrategy.lookup(lookupEvent, index, exprEvaluatorContext);
            if (subsetIter == null) continue;
            while (subsetIter.hasNext()) {
                EventBean[] resultRow = new EventBean[this.numStreams];
                System.arraycopy(prefillPath, 0, resultRow, 0, this.numStreams);
                resultRow[this.historicalStreamNumber] = subsetIter.next();
                result.add(resultRow);
            }
        }
    }

    @Override
    public void print(IndentWriter writer) {
        writer.println("HistoricalDataExecNode");
    }
}

