/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.exec.composite;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.internal.epl.join.exec.composite.CompositeIndexEnterRemove;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CompositeIndexEnterRemoveRange
implements CompositeIndexEnterRemove {
    private final EventPropertyValueGetter propertyGetter;
    private HashSet<EventBean> nullKeys;
    private CompositeIndexEnterRemove next;

    public CompositeIndexEnterRemoveRange(EventPropertyValueGetter propertyGetter) {
        this.propertyGetter = propertyGetter;
    }

    @Override
    public void setNext(CompositeIndexEnterRemove next) {
        this.next = next;
    }

    @Override
    public void getAll(HashSet<EventBean> result, Map parent) {
        if (this.next == null) {
            Map eventMap = parent;
            for (Map.Entry entry : eventMap.entrySet()) {
                result.addAll((Collection)entry.getValue());
            }
        } else {
            Map eventMap = parent;
            for (Map.Entry entry : eventMap.entrySet()) {
                this.next.getAll(result, (Map)entry.getValue());
            }
        }
        if (this.nullKeys != null) {
            result.addAll(this.nullKeys);
        }
    }

    @Override
    public void enter(EventBean theEvent, Map parent) {
        Object sortable = this.propertyGetter.get(theEvent);
        if (sortable == null) {
            if (this.nullKeys == null) {
                this.nullKeys = new HashSet();
            }
            this.nullKeys.add(theEvent);
            return;
        }
        if (this.next == null) {
            Map eventMap = parent;
            HashSet<EventBean> events = (HashSet<EventBean>)eventMap.get(sortable);
            if (events == null) {
                events = new HashSet<EventBean>();
                eventMap.put(sortable, events);
            }
            events.add(theEvent);
        } else {
            TreeMap innerIndex = (TreeMap)parent.get(sortable);
            if (innerIndex == null) {
                innerIndex = new TreeMap();
                parent.put(sortable, innerIndex);
            }
            this.next.enter(theEvent, innerIndex);
        }
    }

    @Override
    public void remove(EventBean theEvent, Map parent) {
        Object sortable = this.propertyGetter.get(theEvent);
        if (sortable == null) {
            if (this.nullKeys != null) {
                this.nullKeys.remove(theEvent);
            }
            return;
        }
        if (this.next == null) {
            Map eventMap = parent;
            if (eventMap == null) {
                return;
            }
            Set events = (Set)eventMap.get(sortable);
            if (events == null) {
                return;
            }
            if (!events.remove(theEvent)) {
                return;
            }
            if (events.isEmpty()) {
                parent.remove(sortable);
            }
        } else {
            Map innerIndex = (Map)parent.get(sortable);
            if (innerIndex == null) {
                return;
            }
            this.next.remove(theEvent, innerIndex);
            if (innerIndex.isEmpty()) {
                parent.remove(sortable);
            }
        }
    }
}

