/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.exec.sorted;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.sorted.PropertySortedEventTable;
import com.espertech.esper.common.internal.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.common.internal.epl.join.exec.sorted.SortedAccessStrategy;
import com.espertech.esper.common.internal.epl.join.exec.sorted.SortedAccessStrategyFactory;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRange;
import com.espertech.esper.common.internal.epl.join.rep.Cursor;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyType;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import java.util.ArrayList;
import java.util.Set;

public class SortedTableLookupStrategy
implements JoinExecTableLookupStrategy {
    private final PropertySortedEventTable index;
    private final SortedAccessStrategy strategy;

    public SortedTableLookupStrategy(int lookupStream, int numStreams, QueryGraphValueEntryRange rangeKeyPair, PropertySortedEventTable index) {
        this.index = index;
        this.strategy = SortedAccessStrategyFactory.make(false, lookupStream, numStreams, rangeKeyPair);
    }

    public PropertySortedEventTable getIndex() {
        return this.index;
    }

    @Override
    public Set<EventBean> lookup(EventBean theEvent, Cursor cursor, ExprEvaluatorContext exprEvaluatorContext) {
        InstrumentationCommon instrumentationCommon = exprEvaluatorContext.getInstrumentationProvider();
        if (instrumentationCommon.activated()) {
            instrumentationCommon.qIndexJoinLookup(this, this.index);
            ArrayList<Object> keys = new ArrayList<Object>(2);
            Set<EventBean> result = this.strategy.lookupCollectKeys(theEvent, this.index, exprEvaluatorContext, keys);
            instrumentationCommon.aIndexJoinLookup(result, keys.size() > 1 ? keys.toArray() : keys.get(0));
            return result;
        }
        return this.strategy.lookup(theEvent, this.index, exprEvaluatorContext);
    }

    @Override
    public LookupStrategyType getLookupStrategyType() {
        return LookupStrategyType.RANGE;
    }
}

