/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.lookup;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class IndexedPropDesc
implements Comparable {
    public static final EPTypeClass EPTYPE = new EPTypeClass(IndexedPropDesc.class);
    private final String indexPropName;
    private final EPTypeClass coercionType;

    public IndexedPropDesc(String indexPropName, EPTypeClass coercionType) {
        this.indexPropName = indexPropName;
        this.coercionType = coercionType;
    }

    public CodegenExpression make() {
        return CodegenExpressionBuilder.newInstance(EPTYPE, CodegenExpressionBuilder.constant(this.indexPropName), CodegenExpressionBuilder.constant(this.coercionType));
    }

    public String getIndexPropName() {
        return this.indexPropName;
    }

    public EPTypeClass getCoercionType() {
        return this.coercionType;
    }

    public static String[] getIndexProperties(IndexedPropDesc[] descList) {
        String[] result = new String[descList.length];
        int count = 0;
        for (IndexedPropDesc desc : descList) {
            result[count++] = desc.getIndexPropName();
        }
        return result;
    }

    public static String[] getIndexProperties(List<IndexedPropDesc> descList) {
        String[] result = new String[descList.size()];
        int count = 0;
        for (IndexedPropDesc desc : descList) {
            result[count++] = desc.getIndexPropName();
        }
        return result;
    }

    public static int getPropertyIndex(String propertyName, IndexedPropDesc[] descList) {
        for (int i = 0; i < descList.length; ++i) {
            if (!descList[i].getIndexPropName().equals(propertyName)) continue;
            return i;
        }
        return -1;
    }

    public static EPTypeClass[] getCoercionTypes(IndexedPropDesc[] descList) {
        EPTypeClass[] result = new EPTypeClass[descList.length];
        int count = 0;
        for (IndexedPropDesc desc : descList) {
            result[count++] = desc.getCoercionType();
        }
        return result;
    }

    public int compareTo(Object o) {
        IndexedPropDesc other = (IndexedPropDesc)o;
        return this.indexPropName.compareTo(other.getIndexPropName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedPropDesc that = (IndexedPropDesc)o;
        if (!this.coercionType.equals(that.coercionType)) {
            return false;
        }
        return this.indexPropName.equals(that.indexPropName);
    }

    public static boolean compare(List<IndexedPropDesc> first, List<IndexedPropDesc> second) {
        if (first.size() != second.size()) {
            return false;
        }
        ArrayList<IndexedPropDesc> copyFirst = new ArrayList<IndexedPropDesc>(first);
        ArrayList<IndexedPropDesc> copySecond = new ArrayList<IndexedPropDesc>(second);
        Comparator<IndexedPropDesc> comparator = new Comparator<IndexedPropDesc>(){

            @Override
            public int compare(IndexedPropDesc o1, IndexedPropDesc o2) {
                return o1.getIndexPropName().compareTo(o2.getIndexPropName());
            }
        };
        Collections.sort(copyFirst, comparator);
        Collections.sort(copySecond, comparator);
        for (int i = 0; i < copyFirst.size(); ++i) {
            if (((IndexedPropDesc)copyFirst.get(i)).equals(copySecond.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.indexPropName.hashCode();
        result = 31 * result + this.coercionType.hashCode();
        return result;
    }

    public static void toQueryPlan(StringWriter writer, IndexedPropDesc[] indexedProps) {
        String delimiter = "";
        for (IndexedPropDesc prop : indexedProps) {
            writer.write(delimiter);
            writer.write(prop.getIndexPropName());
            writer.write("(");
            writer.write(JavaClassHelper.getSimpleNameForClass(prop.getCoercionType()));
            writer.write(")");
            delimiter = ",";
        }
    }

    public static CodegenExpression makeArray(Collection<IndexedPropDesc> items) {
        return IndexedPropDesc.makeArray(items.toArray(new IndexedPropDesc[items.size()]));
    }

    public static CodegenExpression makeArray(IndexedPropDesc[] items) {
        CodegenExpression[] expressions = new CodegenExpression[items.length];
        for (int i = 0; i < items.length; ++i) {
            expressions[i] = items[i].make();
        }
        return CodegenExpressionBuilder.newArrayWithInit(EPTYPE, expressions);
    }
}

