/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplan;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRange;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupIndexReqKey;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWView;
import java.util.Map;

public abstract class TableLookupPlan {
    public static final EPTypeClass EPTYPE = new EPTypeClass(TableLookupPlan.class);
    protected final int lookupStream;
    protected final int indexedStream;
    protected final TableLookupIndexReqKey[] indexNum;
    private ExprEvaluator[] virtualDWHashEvals;
    private EPType[] virtualDWHashTypes;
    private QueryGraphValueEntryRange[] virtualDWRangeEvals;
    private EPType[] virtualDWRangeTypes;

    protected abstract JoinExecTableLookupStrategy makeStrategyInternal(EventTable[] var1, EventType[] var2);

    public TableLookupPlan(int lookupStream, int indexedStream, TableLookupIndexReqKey[] indexNum) {
        this.lookupStream = lookupStream;
        this.indexedStream = indexedStream;
        this.indexNum = indexNum;
    }

    public final JoinExecTableLookupStrategy makeStrategy(AgentInstanceContext agentInstanceContext, Map<TableLookupIndexReqKey, EventTable>[] indexesPerStream, EventType[] eventTypes, VirtualDWView[] viewExternals) {
        EventTable[] eventTables = new EventTable[this.indexNum.length];
        for (int i = 0; i < this.indexNum.length; ++i) {
            eventTables[i] = indexesPerStream[this.indexedStream].get(this.getIndexNum()[i]);
        }
        if (viewExternals[this.indexedStream] != null) {
            return viewExternals[this.indexedStream].getJoinLookupStrategy(this, agentInstanceContext, eventTables, this.lookupStream);
        }
        return this.makeStrategyInternal(eventTables, eventTypes);
    }

    public int getLookupStream() {
        return this.lookupStream;
    }

    public int getIndexedStream() {
        return this.indexedStream;
    }

    public TableLookupIndexReqKey[] getIndexNum() {
        return this.indexNum;
    }

    public ExprEvaluator[] getVirtualDWHashEvals() {
        return this.virtualDWHashEvals;
    }

    public void setVirtualDWHashEvals(ExprEvaluator[] virtualDWHashEvals) {
        this.virtualDWHashEvals = virtualDWHashEvals;
    }

    public EPType[] getVirtualDWHashTypes() {
        return this.virtualDWHashTypes;
    }

    public void setVirtualDWHashTypes(EPType[] virtualDWHashTypes) {
        this.virtualDWHashTypes = virtualDWHashTypes;
    }

    public QueryGraphValueEntryRange[] getVirtualDWRangeEvals() {
        return this.virtualDWRangeEvals;
    }

    public void setVirtualDWRangeEvals(QueryGraphValueEntryRange[] virtualDWRangeEvals) {
        this.virtualDWRangeEvals = virtualDWRangeEvals;
    }

    public EPType[] getVirtualDWRangeTypes() {
        return this.virtualDWRangeTypes;
    }

    public void setVirtualDWRangeTypes(EPType[] virtualDWRangeTypes) {
        this.virtualDWRangeTypes = virtualDWRangeTypes;
    }
}

