/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplan;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenMakeable;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenMakeableUtil;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeForge;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupIndexReqKey;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupKeyDesc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public abstract class TableLookupPlanForge
implements CodegenMakeable<SAIFFInitializeSymbol> {
    protected final int lookupStream;
    protected final int indexedStream;
    protected boolean indexedStreamIsVDW;
    protected EventType[] typesPerStream;
    private TableLookupIndexReqKey[] indexNum;

    public abstract TableLookupKeyDesc getKeyDescriptor();

    public abstract EPTypeClass typeOfPlanFactory();

    public abstract Collection<CodegenExpression> additionalParams(CodegenMethod var1, SAIFFInitializeSymbol var2, CodegenClassScope var3);

    protected TableLookupPlanForge(int lookupStream, int indexedStream, boolean indexedStreamIsVDW, EventType[] typesPerStream, TableLookupIndexReqKey[] indexNum) {
        this.lookupStream = lookupStream;
        this.indexedStream = indexedStream;
        this.indexedStreamIsVDW = indexedStreamIsVDW;
        this.indexNum = indexNum;
        this.typesPerStream = typesPerStream;
    }

    public int getLookupStream() {
        return this.lookupStream;
    }

    public int getIndexedStream() {
        return this.indexedStream;
    }

    public TableLookupIndexReqKey[] getIndexNum() {
        return this.indexNum;
    }

    public String toString() {
        return "lookupStream=" + this.lookupStream + " indexedStream=" + this.indexedStream + " indexNum=" + Arrays.toString(this.indexNum);
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(this.typeOfPlanFactory(), this.getClass(), (CodegenScope)classScope);
        ArrayList<CodegenExpression> params = new ArrayList<CodegenExpression>(6);
        params.add(CodegenExpressionBuilder.constant(this.lookupStream));
        params.add(CodegenExpressionBuilder.constant(this.indexedStream));
        params.add(CodegenMakeableUtil.makeArray((String)"reqIdxKeys", (EPTypeClass)TableLookupIndexReqKey.EPTYPE, (CodegenMakeable[])this.indexNum, this.getClass(), (CodegenMethodScope)method, (SAIFFInitializeSymbol)symbols, (CodegenClassScope)classScope));
        params.addAll(this.additionalParams(method, symbols, classScope));
        method.getBlock().declareVar(this.typeOfPlanFactory(), "plan", CodegenExpressionBuilder.newInstance(this.typeOfPlanFactory(), params.toArray(new CodegenExpression[params.size()])));
        if (this.indexedStreamIsVDW) {
            TableLookupKeyDesc keyDesc = this.getKeyDescriptor();
            ExprNode[] hashes = keyDesc.getHashExpressions();
            QueryGraphValueEntryRangeForge[] ranges = keyDesc.getRanges().toArray(new QueryGraphValueEntryRangeForge[keyDesc.getRanges().size()]);
            EPType[] rangeResults = QueryGraphValueEntryRangeForge.getRangeResultTypes(ranges);
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("plan"), "setVirtualDWHashEvals", ExprNodeUtilityCodegen.codegenEvaluators(hashes, (CodegenMethodScope)method, this.getClass(), classScope)).exprDotMethod(CodegenExpressionBuilder.ref("plan"), "setVirtualDWHashTypes", CodegenExpressionBuilder.constant(ExprNodeUtilityQuery.getExprResultTypes(hashes))).exprDotMethod(CodegenExpressionBuilder.ref("plan"), "setVirtualDWRangeEvals", QueryGraphValueEntryRangeForge.makeArray(ranges, method, symbols, classScope)).exprDotMethod(CodegenExpressionBuilder.ref("plan"), "setVirtualDWRangeTypes", CodegenExpressionBuilder.constant(rangeResults));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("plan"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }
}

