/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplanbuild;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.join.analyze.FilterExprAnalyzer;
import com.espertech.esper.common.internal.epl.join.hint.ExcludePlanHint;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphRangeConsolidateDesc;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphRangeUtil;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueDescForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryCustomForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryCustomKeyForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryCustomOperationForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyedForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyedForgeExpr;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyedForgeProp;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeInForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeRelOpForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairHashKeyIndexForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairInKWMultiIdx;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairInKWSingleIdxForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValuePairRangeIndexForge;
import com.espertech.esper.common.internal.epl.join.queryplan.CoercionDesc;
import com.espertech.esper.common.internal.epl.join.queryplan.CoercionUtil;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexForge;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItemForge;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexUniqueHelper;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropHashKeyForge;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropInKeywordMultiIndex;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropInKeywordSingleIndex;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropPlan;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropRangeKeyForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryPlanIndexBuilder {
    public static QueryPlanIndexForge[] buildIndexSpec(QueryGraphForge queryGraph, EventType[] typePerStream, String[][][] indexedStreamsUniqueProps) {
        int numStreams = queryGraph.getNumStreams();
        QueryPlanIndexForge[] indexSpecs = new QueryPlanIndexForge[numStreams];
        for (int streamIndexed = 0; streamIndexed < numStreams; ++streamIndexed) {
            ArrayList<QueryPlanIndexItemForge> indexesSet = new ArrayList<QueryPlanIndexItemForge>();
            for (int streamLookup = 0; streamLookup < numStreams; ++streamLookup) {
                if (streamIndexed == streamLookup) continue;
                QueryGraphValueForge value = queryGraph.getGraphValue(streamLookup, streamIndexed);
                QueryGraphValuePairHashKeyIndexForge hashKeyAndIndexProps = value.getHashKeyProps();
                String[] hashIndexProps = hashKeyAndIndexProps.getIndexed();
                List<QueryGraphValueEntryHashKeyedForge> hashKeyProps = hashKeyAndIndexProps.getKeys();
                CoercionDesc indexCoercionTypes = CoercionUtil.getCoercionTypesHash(typePerStream, streamLookup, streamIndexed, hashKeyProps, hashIndexProps);
                EPTypeClass[] hashCoercionTypeArr = indexCoercionTypes.getCoercionTypes();
                QueryGraphValuePairRangeIndexForge rangeAndIndexProps = value.getRangeProps();
                String[] rangeIndexProps = rangeAndIndexProps.getIndexed();
                List<QueryGraphValueEntryRangeForge> rangeKeyProps = rangeAndIndexProps.getKeys();
                CoercionDesc rangeCoercionTypes = CoercionUtil.getCoercionTypesRange(typePerStream, streamIndexed, rangeIndexProps, rangeKeyProps);
                EPTypeClass[] rangeCoercionTypeArr = rangeCoercionTypes.getCoercionTypes();
                if (hashIndexProps.length == 0 && rangeIndexProps.length == 0) {
                    List<QueryGraphValuePairInKWMultiIdx> multis;
                    QueryGraphValuePairInKWSingleIdxForge singles = value.getInKeywordSingles();
                    if (!singles.getKey().isEmpty()) {
                        String indexedProp = singles.getIndexed()[0];
                        EPTypeClass indexedType = (EPTypeClass)typePerStream[streamIndexed].getPropertyEPType(indexedProp);
                        QueryPlanIndexItemForge indexItem = new QueryPlanIndexItemForge(new String[]{indexedProp}, new EPTypeClass[]{indexedType}, new String[0], new EPTypeClass[0], false, null, typePerStream[streamIndexed]);
                        QueryPlanIndexBuilder.checkDuplicateOrAdd(indexItem, indexesSet);
                    }
                    if ((multis = value.getInKeywordMulti()).isEmpty()) continue;
                    QueryGraphValuePairInKWMultiIdx multi = multis.get(0);
                    for (ExprNode propIndexed : multi.getIndexed()) {
                        ExprIdentNode identNode = (ExprIdentNode)propIndexed;
                        EPTypeClass type = (EPTypeClass)identNode.getForge().getEvaluationType();
                        QueryPlanIndexItemForge indexItem = new QueryPlanIndexItemForge(new String[]{identNode.getResolvedPropertyName()}, new EPTypeClass[]{type}, new String[0], new EPTypeClass[0], false, null, typePerStream[streamIndexed]);
                        QueryPlanIndexBuilder.checkDuplicateOrAdd(indexItem, indexesSet);
                    }
                    continue;
                }
                boolean unique = false;
                QueryPlanIndexUniqueHelper.ReducedHashKeys reduced = QueryPlanIndexUniqueHelper.reduceToUniqueIfPossible(hashIndexProps, hashCoercionTypeArr, hashKeyProps, indexedStreamsUniqueProps[streamIndexed]);
                if (reduced != null) {
                    hashIndexProps = reduced.getPropertyNames();
                    hashCoercionTypeArr = reduced.getCoercionTypes();
                    unique = true;
                    rangeIndexProps = new String[]{};
                    rangeCoercionTypeArr = new EPTypeClass[]{};
                }
                QueryPlanIndexItemForge proposed = new QueryPlanIndexItemForge(hashIndexProps, hashCoercionTypeArr, rangeIndexProps, rangeCoercionTypeArr, unique, null, typePerStream[streamIndexed]);
                QueryPlanIndexBuilder.checkDuplicateOrAdd(proposed, indexesSet);
            }
            if (indexesSet.isEmpty()) {
                indexesSet.add(new QueryPlanIndexItemForge(new String[0], new EPTypeClass[0], new String[0], new EPTypeClass[0], false, null, typePerStream[streamIndexed]));
            }
            indexSpecs[streamIndexed] = QueryPlanIndexForge.makeIndex(indexesSet);
        }
        return indexSpecs;
    }

    public static SubordPropPlan getJoinProps(ExprNode filterExpr, int outsideStreamCount, EventType[] allStreamTypesZeroIndexed, ExcludePlanHint excludePlanHint) {
        if (filterExpr == null) {
            return new SubordPropPlan();
        }
        QueryGraphForge queryGraph = new QueryGraphForge(outsideStreamCount + 1, excludePlanHint, true);
        FilterExprAnalyzer.analyze(filterExpr, queryGraph, false);
        LinkedHashMap<String, SubordPropHashKeyForge> joinProps = new LinkedHashMap<String, SubordPropHashKeyForge>();
        LinkedHashMap<String, SubordPropRangeKeyForge> rangeProps = new LinkedHashMap<String, SubordPropRangeKeyForge>();
        Map<QueryGraphValueEntryCustomKeyForge, QueryGraphValueEntryCustomOperationForge> customIndexOps = Collections.emptyMap();
        for (int stream = 0; stream < outsideStreamCount; ++stream) {
            int lookupStream = stream + 1;
            QueryGraphValueForge queryGraphValue = queryGraph.getGraphValue(lookupStream, 0);
            QueryGraphValuePairHashKeyIndexForge hashKeysAndIndexes = queryGraphValue.getHashKeyProps();
            for (QueryGraphValueDescForge item : queryGraphValue.getItems()) {
                if (!(item.getEntry() instanceof QueryGraphValueEntryCustomForge)) continue;
                if (customIndexOps.isEmpty()) {
                    customIndexOps = new HashMap<QueryGraphValueEntryCustomKeyForge, QueryGraphValueEntryCustomOperationForge>();
                }
                QueryGraphValueEntryCustomForge custom = (QueryGraphValueEntryCustomForge)item.getEntry();
                custom.mergeInto(customIndexOps);
            }
            List<QueryGraphValueEntryHashKeyedForge> keyPropertiesJoin = hashKeysAndIndexes.getKeys();
            String[] indexPropertiesJoin = hashKeysAndIndexes.getIndexed();
            if (!keyPropertiesJoin.isEmpty()) {
                if (keyPropertiesJoin.size() != indexPropertiesJoin.length) {
                    throw new IllegalStateException("Invalid query key and index property collection for stream " + stream);
                }
                for (int i = 0; i < keyPropertiesJoin.size(); ++i) {
                    SubordPropHashKeyForge desc;
                    EPTypeClass indexedPropType;
                    QueryGraphValueEntryHashKeyedForge keyDesc = keyPropertiesJoin.get(i);
                    ExprNode compareNode = keyDesc.getKeyExpr();
                    EPType keyPropType = JavaClassHelper.getBoxedType(compareNode.getForge().getEvaluationType());
                    EPTypeClass coercionType = indexedPropType = (EPTypeClass)JavaClassHelper.getBoxedType(allStreamTypesZeroIndexed[0].getPropertyEPType(indexPropertiesJoin[i]));
                    if (keyPropType != indexedPropType) {
                        coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, indexedPropType);
                    }
                    if (keyPropertiesJoin.get(i) instanceof QueryGraphValueEntryHashKeyedForgeExpr) {
                        QueryGraphValueEntryHashKeyedForgeExpr keyExpr = (QueryGraphValueEntryHashKeyedForgeExpr)keyPropertiesJoin.get(i);
                        Integer keyStreamNum = keyExpr.isRequiresKey() ? Integer.valueOf(stream) : null;
                        desc = new SubordPropHashKeyForge(keyDesc, keyStreamNum, coercionType);
                    } else {
                        QueryGraphValueEntryHashKeyedForgeProp prop = (QueryGraphValueEntryHashKeyedForgeProp)keyDesc;
                        desc = new SubordPropHashKeyForge(prop, stream, coercionType);
                    }
                    joinProps.put(indexPropertiesJoin[i], desc);
                }
            }
            QueryGraphValuePairRangeIndexForge rangeKeysAndIndexes = queryGraphValue.getRangeProps();
            String[] rangeIndexes = rangeKeysAndIndexes.getIndexed();
            List<QueryGraphValueEntryRangeForge> rangeDescs = rangeKeysAndIndexes.getKeys();
            if (rangeDescs.isEmpty()) continue;
            int count = -1;
            for (QueryGraphValueEntryRangeForge rangeDesc : rangeDescs) {
                String rangeIndexProp;
                SubordPropRangeKeyForge subqRangeDesc;
                if ((subqRangeDesc = rangeProps.get(rangeIndexProp = rangeIndexes[++count])) != null) {
                    EPTypeClass indexedPropType;
                    ExprNode end;
                    ExprNode start;
                    if (subqRangeDesc.getRangeInfo().getType().isRange()) continue;
                    QueryGraphValueEntryRangeRelOpForge relOpOther = (QueryGraphValueEntryRangeRelOpForge)subqRangeDesc.getRangeInfo();
                    QueryGraphValueEntryRangeRelOpForge relOpThis = (QueryGraphValueEntryRangeRelOpForge)rangeDesc;
                    QueryGraphRangeConsolidateDesc opsDesc = QueryGraphRangeUtil.getCanConsolidate(relOpThis.getType(), relOpOther.getType());
                    if (opsDesc == null) continue;
                    if (!opsDesc.isReverse()) {
                        start = relOpOther.getExpression();
                        end = relOpThis.getExpression();
                    } else {
                        start = relOpThis.getExpression();
                        end = relOpOther.getExpression();
                    }
                    boolean allowRangeReversal = relOpOther.isBetweenPart() && relOpThis.isBetweenPart();
                    QueryGraphValueEntryRangeInForge rangeIn = new QueryGraphValueEntryRangeInForge(opsDesc.getType(), start, end, allowRangeReversal);
                    EPTypeClass coercionType = indexedPropType = (EPTypeClass)JavaClassHelper.getBoxedType(allStreamTypesZeroIndexed[0].getPropertyEPType(rangeIndexProp));
                    EPTypeClass proposedType = CoercionUtil.getCoercionTypeRangeIn(indexedPropType, rangeIn.getExprStart(), rangeIn.getExprEnd());
                    if (proposedType != null && proposedType != indexedPropType) {
                        coercionType = proposedType;
                    }
                    subqRangeDesc = new SubordPropRangeKeyForge(rangeIn, coercionType);
                    rangeProps.put(rangeIndexProp, subqRangeDesc);
                    continue;
                }
                if (rangeDesc.getType().isRange()) {
                    EPTypeClass indexedPropType;
                    QueryGraphValueEntryRangeInForge rangeIn = (QueryGraphValueEntryRangeInForge)rangeDesc;
                    EPTypeClass coercionType = indexedPropType = (EPTypeClass)JavaClassHelper.getBoxedType(allStreamTypesZeroIndexed[0].getPropertyEPType(rangeIndexProp));
                    EPTypeClass proposedType = CoercionUtil.getCoercionTypeRangeIn(indexedPropType, rangeIn.getExprStart(), rangeIn.getExprEnd());
                    if (proposedType != null && proposedType.getType() != indexedPropType.getType()) {
                        coercionType = proposedType;
                    }
                    subqRangeDesc = new SubordPropRangeKeyForge(rangeDesc, coercionType);
                } else {
                    EPTypeClass indexedPropType;
                    QueryGraphValueEntryRangeRelOpForge relOp = (QueryGraphValueEntryRangeRelOpForge)rangeDesc;
                    EPType keyPropType = relOp.getExpression().getForge().getEvaluationType();
                    EPTypeClass coercionType = indexedPropType = (EPTypeClass)JavaClassHelper.getBoxedType(allStreamTypesZeroIndexed[0].getPropertyEPType(rangeIndexProp));
                    if (!keyPropType.equals(indexedPropType)) {
                        coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, indexedPropType);
                    }
                    subqRangeDesc = new SubordPropRangeKeyForge(rangeDesc, coercionType);
                }
                rangeProps.put(rangeIndexProp, subqRangeDesc);
            }
        }
        SubordPropInKeywordSingleIndex inKeywordSingleIdxProp = null;
        SubordPropInKeywordMultiIndex inKeywordMultiIdxProp = null;
        if (joinProps.isEmpty() && rangeProps.isEmpty()) {
            for (int stream = 0; stream < outsideStreamCount; ++stream) {
                List<QueryGraphValuePairInKWMultiIdx> inkwMultis;
                EPTypeClass coercionType;
                EPType type;
                int lookupStream = stream + 1;
                QueryGraphValueForge queryGraphValue = queryGraph.getGraphValue(lookupStream, 0);
                QueryGraphValuePairInKWSingleIdxForge inkwSingles = queryGraphValue.getInKeywordSingles();
                if (inkwSingles.getIndexed().length != 0) {
                    ExprNode[] keys = inkwSingles.getKey().get(0).getKeyExprs();
                    String key = inkwSingles.getIndexed()[0];
                    if (inKeywordSingleIdxProp != null) continue;
                    type = keys[0].getForge().getEvaluationType();
                    coercionType = type == null || type == EPTypeNull.INSTANCE ? null : (EPTypeClass)type;
                    inKeywordSingleIdxProp = new SubordPropInKeywordSingleIndex(key, coercionType, keys);
                }
                if (!(inkwMultis = queryGraphValue.getInKeywordMulti()).isEmpty()) {
                    QueryGraphValuePairInKWMultiIdx multi = inkwMultis.get(0);
                    type = multi.getIndexed()[0].getForge().getEvaluationType();
                    coercionType = type == null || type == EPTypeNull.INSTANCE ? null : (EPTypeClass)type;
                    inKeywordMultiIdxProp = new SubordPropInKeywordMultiIndex(ExprNodeUtilityQuery.getIdentResolvedPropertyNames(multi.getIndexed()), coercionType, multi.getKey().getKeyExpr());
                }
                if (inKeywordSingleIdxProp == null || inKeywordMultiIdxProp == null) continue;
                inKeywordMultiIdxProp = null;
            }
        }
        return new SubordPropPlan(joinProps, rangeProps, inKeywordSingleIdxProp, inKeywordMultiIdxProp, customIndexOps);
    }

    private static void checkDuplicateOrAdd(QueryPlanIndexItemForge proposed, List<QueryPlanIndexItemForge> indexesSet) {
        boolean found = false;
        for (QueryPlanIndexItemForge index : indexesSet) {
            if (!proposed.equalsCompareSortedProps(index)) continue;
            found = true;
            break;
        }
        if (!found) {
            indexesSet.add(proposed);
        }
    }
}

