/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplanouter;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.common.internal.epl.join.exec.outer.LookupInstructionExec;
import com.espertech.esper.common.internal.epl.join.queryplan.HistoricalDataPlanNode;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupIndexReqKey;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupPlan;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWView;
import com.espertech.esper.common.internal.util.IndentWriter;
import com.espertech.esper.common.internal.view.core.Viewable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public class LookupInstructionPlan {
    public static final EPTypeClass EPTYPE = new EPTypeClass(LookupInstructionPlan.class);
    private final int fromStream;
    private final String fromStreamName;
    private final int[] toStreams;
    private final TableLookupPlan[] lookupPlans;
    private final boolean[] requiredPerStream;
    private final HistoricalDataPlanNode[] historicalPlans;

    public LookupInstructionPlan(int fromStream, String fromStreamName, int[] toStreams, TableLookupPlan[] lookupPlans, HistoricalDataPlanNode[] historicalPlans, boolean[] requiredPerStream) {
        if (toStreams.length != lookupPlans.length) {
            throw new IllegalArgumentException("Invalid number of lookup plans for each stream");
        }
        if (requiredPerStream.length < lookupPlans.length) {
            throw new IllegalArgumentException("Invalid required per stream array");
        }
        if (fromStream < 0 || fromStream >= requiredPerStream.length) {
            throw new IllegalArgumentException("Invalid from stream");
        }
        this.fromStream = fromStream;
        this.fromStreamName = fromStreamName;
        this.toStreams = toStreams;
        this.lookupPlans = lookupPlans;
        this.historicalPlans = historicalPlans;
        this.requiredPerStream = requiredPerStream;
    }

    public LookupInstructionExec makeExec(AgentInstanceContext agentInstanceContext, Map<TableLookupIndexReqKey, EventTable>[] indexesPerStream, EventType[] streamTypes, Viewable[] streamViews, VirtualDWView[] viewExternal) {
        JoinExecTableLookupStrategy[] strategies = new JoinExecTableLookupStrategy[this.lookupPlans.length];
        for (int i = 0; i < this.lookupPlans.length; ++i) {
            strategies[i] = this.lookupPlans[i] != null ? this.lookupPlans[i].makeStrategy(agentInstanceContext, indexesPerStream, streamTypes, viewExternal) : this.historicalPlans[i].makeOuterJoinStategy(streamViews);
        }
        return new LookupInstructionExec(this.fromStream, this.fromStreamName, this.toStreams, strategies, this.requiredPerStream);
    }

    public void print(IndentWriter writer) {
        writer.println("LookupInstructionPlan fromStream=" + this.fromStream + " fromStreamName=" + this.fromStreamName + " toStreams=" + Arrays.toString(this.toStreams));
        writer.incrIndent();
        for (int i = 0; i < this.lookupPlans.length; ++i) {
            if (this.lookupPlans[i] != null) {
                writer.println("plan " + i + " :" + this.lookupPlans[i].toString());
                continue;
            }
            writer.println("plan " + i + " : no lookup plan");
        }
        writer.decrIndent();
    }

    public void addIndexes(HashSet<TableLookupIndexReqKey> usedIndexes) {
        for (int i = 0; i < this.lookupPlans.length; ++i) {
            if (this.lookupPlans[i] == null) continue;
            usedIndexes.addAll(Arrays.asList(this.lookupPlans[i].getIndexNum()));
        }
    }

    public int getFromStream() {
        return this.fromStream;
    }

    public String getFromStreamName() {
        return this.fromStreamName;
    }

    public int[] getToStreams() {
        return this.toStreams;
    }

    public TableLookupPlan[] getLookupPlans() {
        return this.lookupPlans;
    }

    public boolean[] getRequiredPerStream() {
        return this.requiredPerStream;
    }

    public Object[] getHistoricalPlans() {
        return this.historicalPlans;
    }
}

