/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplanouter;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenMakeable;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenMakeableUtil;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.join.queryplan.HistoricalDataPlanNode;
import com.espertech.esper.common.internal.epl.join.queryplan.HistoricalDataPlanNodeForge;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupIndexReqKey;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupPlan;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupPlanForge;
import com.espertech.esper.common.internal.epl.join.queryplanouter.LookupInstructionPlan;
import com.espertech.esper.common.internal.util.IndentWriter;
import java.util.Arrays;
import java.util.HashSet;

public class LookupInstructionPlanForge
implements CodegenMakeable<SAIFFInitializeSymbol> {
    private final int fromStream;
    private final String fromStreamName;
    private final int[] toStreams;
    private final TableLookupPlanForge[] lookupPlans;
    private final boolean[] requiredPerStream;
    private final HistoricalDataPlanNodeForge[] historicalPlans;

    public LookupInstructionPlanForge(int fromStream, String fromStreamName, int[] toStreams, TableLookupPlanForge[] lookupPlans, HistoricalDataPlanNodeForge[] historicalPlans, boolean[] requiredPerStream) {
        if (toStreams.length != lookupPlans.length) {
            throw new IllegalArgumentException("Invalid number of lookup plans for each stream");
        }
        if (requiredPerStream.length < lookupPlans.length) {
            throw new IllegalArgumentException("Invalid required per stream array");
        }
        if (fromStream < 0 || fromStream >= requiredPerStream.length) {
            throw new IllegalArgumentException("Invalid from stream");
        }
        this.fromStream = fromStream;
        this.fromStreamName = fromStreamName;
        this.toStreams = toStreams;
        this.lookupPlans = lookupPlans;
        this.historicalPlans = historicalPlans;
        this.requiredPerStream = requiredPerStream;
    }

    public void print(IndentWriter writer) {
        writer.println("LookupInstructionPlan fromStream=" + this.fromStream + " fromStreamName=" + this.fromStreamName + " toStreams=" + Arrays.toString(this.toStreams));
        writer.incrIndent();
        for (int i = 0; i < this.lookupPlans.length; ++i) {
            if (this.lookupPlans[i] != null) {
                writer.println("plan " + i + " :" + this.lookupPlans[i].toString());
                continue;
            }
            writer.println("plan " + i + " : no lookup plan");
        }
        writer.decrIndent();
    }

    public void addIndexes(HashSet<TableLookupIndexReqKey> usedIndexes) {
        for (int i = 0; i < this.lookupPlans.length; ++i) {
            if (this.lookupPlans[i] == null) continue;
            usedIndexes.addAll(Arrays.asList(this.lookupPlans[i].getIndexNum()));
        }
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        return CodegenExpressionBuilder.newInstance(LookupInstructionPlan.EPTYPE, CodegenExpressionBuilder.constant(this.fromStream), CodegenExpressionBuilder.constant(this.fromStreamName), CodegenExpressionBuilder.constant(this.toStreams), CodegenMakeableUtil.makeArray((String)"lookupPlans", (EPTypeClass)TableLookupPlan.EPTYPE, (CodegenMakeable[])this.lookupPlans, this.getClass(), (CodegenMethodScope)parent, (SAIFFInitializeSymbol)symbols, (CodegenClassScope)classScope), CodegenMakeableUtil.makeArray((String)"historicalPlans", (EPTypeClass)HistoricalDataPlanNode.EPTYPE, (CodegenMakeable[])this.historicalPlans, this.getClass(), (CodegenMethodScope)parent, (SAIFFInitializeSymbol)symbols, (CodegenClassScope)classScope), CodegenExpressionBuilder.constant(this.requiredPerStream));
    }

    public int getFromStream() {
        return this.fromStream;
    }

    public String getFromStreamName() {
        return this.fromStreamName;
    }

    public int[] getToStreams() {
        return this.toStreams;
    }

    public TableLookupPlanForge[] getLookupPlans() {
        return this.lookupPlans;
    }

    public boolean[] getRequiredPerStream() {
        return this.requiredPerStream;
    }

    public HistoricalDataPlanNodeForge[] getHistoricalPlans() {
        return this.historicalPlans;
    }
}

