/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.strategy;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.join.strategy.ExecNode;
import com.espertech.esper.common.internal.epl.join.strategy.QueryStrategy;
import java.util.ArrayDeque;
import java.util.Set;

public class ExecNodeQueryStrategy
implements QueryStrategy {
    private int forStream;
    private int numStreams;
    private ExecNode execNode;

    public ExecNodeQueryStrategy(int forStream, int numStreams, ExecNode execNode) {
        this.forStream = forStream;
        this.numStreams = numStreams;
        this.execNode = execNode;
    }

    @Override
    public void lookup(EventBean[] lookupEvents, Set<MultiKeyArrayOfKeys<EventBean>> joinSet, ExprEvaluatorContext exprEvaluatorContext) {
        if (lookupEvents == null || lookupEvents.length == 0) {
            return;
        }
        ArrayDeque<EventBean[]> results = new ArrayDeque<EventBean[]>();
        for (EventBean theEvent : lookupEvents) {
            EventBean[] prototype = new EventBean[this.numStreams];
            prototype[this.forStream] = theEvent;
            this.execNode.process(theEvent, prototype, results, exprEvaluatorContext);
            for (EventBean[] row : results) {
                joinSet.add(new MultiKeyArrayOfKeys<EventBean>(row));
            }
            results.clear();
        }
    }

    protected int getForStream() {
        return this.forStream;
    }

    protected int getNumStreams() {
        return this.numStreams;
    }

    protected ExecNode getExecNode() {
        return this.execNode;
    }
}

