/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.lookup;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTable;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.common.internal.epl.lookup.SubordHashedTableLookupStrategyExprFactory;
import com.espertech.esper.common.internal.epl.lookup.SubordTableLookupStrategy;
import java.util.Collection;
import java.util.Set;

public class SubordHashedTableLookupStrategyExpr
implements SubordTableLookupStrategy {
    private final SubordHashedTableLookupStrategyExprFactory factory;
    private final PropertyHashedEventTable index;
    private EventBean[] events;

    public SubordHashedTableLookupStrategyExpr(SubordHashedTableLookupStrategyExprFactory factory, PropertyHashedEventTable index) {
        this.factory = factory;
        this.events = new EventBean[factory.numStreamsOuter + 1];
        this.index = index;
    }

    public PropertyHashedEventTable getIndex() {
        return this.index;
    }

    @Override
    public Collection<EventBean> lookup(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        if (context.getInstrumentationProvider().activated()) {
            context.getInstrumentationProvider().qIndexSubordLookup(this, this.index, null);
            Object key = this.getKey(eventsPerStream, context);
            Set<EventBean> result = this.index.lookup(key);
            context.getInstrumentationProvider().aIndexSubordLookup(result, key);
            return result;
        }
        Object key = this.getKey(eventsPerStream, context);
        return this.index.lookup(key);
    }

    protected Object getKey(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        System.arraycopy(eventsPerStream, 0, this.events, 1, eventsPerStream.length);
        return this.factory.evaluator.evaluate(this.events, true, context);
    }

    @Override
    public LookupStrategyDesc getStrategyDesc() {
        return this.factory.getLookupStrategyDesc();
    }

    @Override
    public String toQueryPlan() {
        return this.factory.toQueryPlan();
    }
}

