/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.lookupplansubord;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.CreateIndexItem;
import com.espertech.esper.common.internal.compile.stage1.spec.CreateIndexType;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeIdentifierAndStreamRefVisitor;
import com.espertech.esper.common.internal.epl.index.advanced.index.service.AdvancedIndexFactoryProvider;
import com.espertech.esper.common.internal.epl.index.advanced.index.service.EventAdvancedIndexProvisionCompileTime;
import com.espertech.esper.common.internal.epl.join.hint.IndexHintInstruction;
import com.espertech.esper.common.internal.epl.join.hint.IndexHintInstructionBust;
import com.espertech.esper.common.internal.epl.join.hint.IndexHintInstructionExplicit;
import com.espertech.esper.common.internal.epl.join.hint.IndexHintInstructionIndexName;
import com.espertech.esper.common.internal.epl.join.lookup.IndexMultiKey;
import com.espertech.esper.common.internal.epl.join.lookup.IndexedPropDesc;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItemForge;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexEntryBase;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexMetadataEntry;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTableIndexUtil {
    private static final Logger log = LoggerFactory.getLogger(EventTableIndexUtil.class);
    private static final IndexComparatorShortestPath INDEX_COMPARATOR_INSTANCE = new IndexComparatorShortestPath();

    public static QueryPlanIndexItemForge validateCompileExplicitIndex(String indexName, boolean unique, List<CreateIndexItem> columns, EventType eventType, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        ArrayList<IndexedPropDesc> hashProps = new ArrayList<IndexedPropDesc>();
        ArrayList<IndexedPropDesc> btreeProps = new ArrayList<IndexedPropDesc>();
        HashSet<String> indexedColumns = new HashSet<String>();
        EventAdvancedIndexProvisionCompileTime advancedIndexProvisionDesc = null;
        for (CreateIndexItem columnDesc : columns) {
            String indexType = columnDesc.getType().toLowerCase(Locale.ENGLISH).trim();
            if (indexType.equals(CreateIndexType.HASH.getNameLower()) || indexType.equals(CreateIndexType.BTREE.getNameLower())) {
                EventTableIndexUtil.validateBuiltin(columnDesc, eventType, hashProps, btreeProps, indexedColumns);
                continue;
            }
            if (advancedIndexProvisionDesc != null) {
                throw new ExprValidationException("Nested advanced-type indexes are not supported");
            }
            advancedIndexProvisionDesc = EventTableIndexUtil.validateAdvanced(indexName, indexType, columnDesc, eventType, statementRawInfo, services);
        }
        if (unique && !btreeProps.isEmpty()) {
            throw new ExprValidationException("Combination of unique index with btree (range) is not supported");
        }
        if (!(btreeProps.isEmpty() && hashProps.isEmpty() || advancedIndexProvisionDesc == null)) {
            throw new ExprValidationException("Combination of hash/btree columns an advanced-type indexes is not supported");
        }
        return new QueryPlanIndexItemForge(hashProps, btreeProps, unique, advancedIndexProvisionDesc, eventType);
    }

    private static EventAdvancedIndexProvisionCompileTime validateAdvanced(String indexName, String indexType, CreateIndexItem columnDesc, EventType eventType, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        AdvancedIndexFactoryProvider provider;
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(eventType, null, false);
        ExprValidationContext validationContextColumns = new ExprValidationContextBuilder(streamTypeService, statementRawInfo, services).withDisablePropertyExpressionEventCollCache(true).build();
        ExprNode[] columns = columnDesc.getExpressions().toArray(new ExprNode[columnDesc.getExpressions().size()]);
        ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.CREATEINDEXCOLUMN, columns, validationContextColumns);
        ExprNodeUtilityValidate.validatePlainExpression(ExprNodeOrigin.CREATEINDEXCOLUMN, columns);
        ExprNode[] parameters = null;
        if (columnDesc.getParameters() != null && !columnDesc.getParameters().isEmpty()) {
            parameters = columnDesc.getParameters().toArray(new ExprNode[columnDesc.getParameters().size()]);
            ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.CREATEINDEXPARAMETER, parameters, validationContextColumns);
            ExprNodeUtilityValidate.validatePlainExpression(ExprNodeOrigin.CREATEINDEXPARAMETER, parameters);
            ExprNodeIdentifierAndStreamRefVisitor visitor = new ExprNodeIdentifierAndStreamRefVisitor(false);
            for (ExprNode param : columnDesc.getParameters()) {
                param.accept(visitor);
                if (visitor.getRefs().isEmpty()) continue;
                throw new ExprValidationException("Index parameters may not refer to event properties");
            }
        }
        try {
            provider = services.getClasspathImportServiceCompileTime().resolveAdvancedIndexProvider(indexType);
        }
        catch (ClasspathImportException ex) {
            throw new ExprValidationException(ex.getMessage(), ex);
        }
        return provider.validateEventIndex(indexName, indexType, columns, parameters);
    }

    private static void validateBuiltin(CreateIndexItem columnDesc, EventType eventType, List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps, Set<String> indexedColumns) throws ExprValidationException {
        if (columnDesc.getExpressions().isEmpty()) {
            throw new ExprValidationException("Invalid empty list of index expressions");
        }
        if (columnDesc.getExpressions().size() > 1) {
            throw new ExprValidationException("Invalid multiple index expressions for index type '" + columnDesc.getType() + "'");
        }
        ExprNode expression = columnDesc.getExpressions().get(0);
        if (!(expression instanceof ExprIdentNode)) {
            throw new ExprValidationException("Invalid index expression '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(expression) + "'");
        }
        ExprIdentNode identNode = (ExprIdentNode)expression;
        if (identNode.getFullUnresolvedName().contains(".")) {
            throw new ExprValidationException("Invalid index expression '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(expression) + "'");
        }
        String columnName = identNode.getFullUnresolvedName();
        EPType type = JavaClassHelper.getBoxedType(eventType.getPropertyEPType(columnName));
        if (type == null) {
            throw new ExprValidationException("Property named '" + columnName + "' not found");
        }
        if (type == EPTypeNull.INSTANCE) {
            throw new ExprValidationException("Property named '" + columnName + "' is null-typed");
        }
        if (!indexedColumns.add(columnName)) {
            throw new ExprValidationException("Property named '" + columnName + "' has been declared more then once");
        }
        IndexedPropDesc desc = new IndexedPropDesc(columnName, (EPTypeClass)type);
        String indexType = columnDesc.getType().toLowerCase(Locale.ENGLISH);
        if (indexType.equals(CreateIndexType.HASH.getNameLower())) {
            hashProps.add(desc);
        } else {
            btreeProps.add(desc);
        }
    }

    public static IndexMultiKey findIndexConsiderTyping(Map<IndexMultiKey, EventTableIndexMetadataEntry> tableIndexesRefCount, List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps, List<IndexHintInstruction> optionalIndexHintInstructions) {
        IndexMultiKey found;
        if (hashProps.isEmpty() && btreeProps.isEmpty()) {
            throw new IllegalArgumentException("Invalid zero element list for hash and btree columns");
        }
        Map<IndexMultiKey, EventTableIndexEntryBase> indexCandidates = EventTableIndexUtil.findCandidates(tableIndexesRefCount, hashProps, btreeProps);
        if (optionalIndexHintInstructions != null && (found = EventTableIndexUtil.findByIndexHint(indexCandidates, optionalIndexHintInstructions)) != null) {
            return found;
        }
        IndexMultiKey indexPropKeyMatch = EventTableIndexUtil.findExactMatchNameAndType(tableIndexesRefCount.keySet(), true, hashProps, btreeProps);
        if (indexPropKeyMatch == null) {
            indexPropKeyMatch = EventTableIndexUtil.findExactMatchNameAndType(tableIndexesRefCount.keySet(), false, hashProps, btreeProps);
        }
        if (indexPropKeyMatch != null) {
            return indexPropKeyMatch;
        }
        if (indexCandidates.isEmpty()) {
            return null;
        }
        return EventTableIndexUtil.getBestCandidate(indexCandidates).getFirst();
    }

    public static Pair<IndexMultiKey, EventTableIndexEntryBase> findIndexBestAvailable(Map<IndexMultiKey, ? extends EventTableIndexEntryBase> tablesAvailable, Set<String> keyPropertyNames, Set<String> rangePropertyNames, List<IndexHintInstruction> optionalIndexHintInstructions) {
        IndexMultiKey found;
        if (keyPropertyNames.isEmpty() && rangePropertyNames.isEmpty()) {
            return null;
        }
        ArrayList<IndexedPropDesc> hashProps = new ArrayList<IndexedPropDesc>();
        for (String string : keyPropertyNames) {
            hashProps.add(new IndexedPropDesc(string, null));
        }
        ArrayList<IndexedPropDesc> rangeProps = new ArrayList<IndexedPropDesc>();
        for (String rangePropertyName : rangePropertyNames) {
            rangeProps.add(new IndexedPropDesc(rangePropertyName, null));
        }
        Map<IndexMultiKey, EventTableIndexEntryBase> map = EventTableIndexUtil.findCandidates(tablesAvailable, hashProps, rangeProps);
        if (optionalIndexHintInstructions != null && (found = EventTableIndexUtil.findByIndexHint(map, optionalIndexHintInstructions)) != null) {
            return EventTableIndexUtil.getPair(tablesAvailable, found);
        }
        if (map == null || map.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("No index found.");
            }
            return null;
        }
        return EventTableIndexUtil.getBestCandidate(map);
    }

    private static Pair<IndexMultiKey, EventTableIndexEntryBase> getBestCandidate(Map<IndexMultiKey, EventTableIndexEntryBase> indexCandidates) {
        ArrayList<IndexMultiKey> indexes = new ArrayList<IndexMultiKey>();
        for (Map.Entry<IndexMultiKey, EventTableIndexEntryBase> entry : indexCandidates.entrySet()) {
            if (!entry.getKey().isUnique()) continue;
            indexes.add(entry.getKey());
        }
        if (!indexes.isEmpty()) {
            Collections.sort(indexes, INDEX_COMPARATOR_INSTANCE);
            return EventTableIndexUtil.getPair(indexCandidates, (IndexMultiKey)indexes.get(0));
        }
        indexes.clear();
        indexes.addAll(indexCandidates.keySet());
        if (indexes.size() > 1) {
            Collections.sort(indexes, INDEX_COMPARATOR_INSTANCE);
        }
        return EventTableIndexUtil.getPair(indexCandidates, (IndexMultiKey)indexes.get(0));
    }

    public static IndexMultiKey findByIndexHint(Map<IndexMultiKey, ? extends EventTableIndexEntryBase> indexCandidates, List<IndexHintInstruction> instructions) {
        for (IndexHintInstruction instruction : instructions) {
            IndexMultiKey found;
            String indexName;
            IndexMultiKey found2;
            if (instruction instanceof IndexHintInstructionIndexName && (found2 = EventTableIndexUtil.findExplicitIndexByName(indexCandidates, indexName = ((IndexHintInstructionIndexName)instruction).getIndexName())) != null) {
                return found2;
            }
            if (instruction instanceof IndexHintInstructionExplicit && (found = EventTableIndexUtil.findExplicitIndexAnyName(indexCandidates)) != null) {
                return found;
            }
            if (!(instruction instanceof IndexHintInstructionBust)) continue;
            throw new EPException("Failed to plan index access, index hint busted out");
        }
        return null;
    }

    public static IndexMultiKey findExactMatchNameAndType(Set<IndexMultiKey> indexMultiKeys, IndexMultiKey proposed) {
        for (IndexMultiKey existing : indexMultiKeys) {
            if (!existing.equals(proposed)) continue;
            return existing;
        }
        return null;
    }

    public static IndexMultiKey findExactMatchNameAndType(Set<IndexMultiKey> indexMultiKeys, boolean unique, List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps) {
        for (IndexMultiKey existing : indexMultiKeys) {
            if (!EventTableIndexUtil.isExactMatch(existing, unique, hashProps, btreeProps)) continue;
            return existing;
        }
        return null;
    }

    private static Map<IndexMultiKey, ? extends EventTableIndexEntryBase> findCandidates(Map<IndexMultiKey, ? extends EventTableIndexEntryBase> indexes, List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps) {
        HashMap<IndexMultiKey, EventTableIndexEntryBase> indexCandidates = new HashMap<IndexMultiKey, EventTableIndexEntryBase>();
        for (Map.Entry<IndexMultiKey, ? extends EventTableIndexEntryBase> entry : indexes.entrySet()) {
            boolean matches;
            if (entry.getKey().getAdvancedIndexDesc() != null || !(matches = EventTableIndexUtil.indexMatchesProvided(entry.getKey(), hashProps, btreeProps))) continue;
            indexCandidates.put(entry.getKey(), entry.getValue());
        }
        return indexCandidates;
    }

    private static IndexMultiKey findExplicitIndexByName(Map<IndexMultiKey, ? extends EventTableIndexEntryBase> indexCandidates, String name) {
        for (Map.Entry<IndexMultiKey, ? extends EventTableIndexEntryBase> entry : indexCandidates.entrySet()) {
            if (entry.getValue().getOptionalIndexName() == null || !entry.getValue().getOptionalIndexName().equals(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    private static IndexMultiKey findExplicitIndexAnyName(Map<IndexMultiKey, ? extends EventTableIndexEntryBase> indexCandidates) {
        for (Map.Entry<IndexMultiKey, ? extends EventTableIndexEntryBase> entry : indexCandidates.entrySet()) {
            if (entry.getValue().getOptionalIndexName() == null) continue;
            return entry.getKey();
        }
        return null;
    }

    private static boolean indexHashIsProvided(IndexedPropDesc hashPropIndexed, List<IndexedPropDesc> hashPropsProvided) {
        for (IndexedPropDesc hashPropProvided : hashPropsProvided) {
            boolean nameMatch = hashPropProvided.getIndexPropName().equals(hashPropIndexed.getIndexPropName());
            boolean typeMatch = true;
            if (hashPropProvided.getCoercionType() != null && !JavaClassHelper.isSubclassOrImplementsInterface((EPType)JavaClassHelper.getBoxedType(hashPropProvided.getCoercionType()), JavaClassHelper.getBoxedType(hashPropIndexed.getCoercionType()))) {
                typeMatch = false;
            }
            if (!nameMatch || !typeMatch) continue;
            return true;
        }
        return false;
    }

    private static boolean isExactMatch(IndexMultiKey existing, boolean unique, List<IndexedPropDesc> hashProps, List<IndexedPropDesc> btreeProps) {
        if (existing.isUnique() != unique) {
            return false;
        }
        if (!IndexedPropDesc.compare(Arrays.asList(existing.getHashIndexedProps()), hashProps)) {
            return false;
        }
        return IndexedPropDesc.compare(Arrays.asList(existing.getRangeIndexedProps()), btreeProps);
    }

    private static boolean indexMatchesProvided(IndexMultiKey indexDesc, List<IndexedPropDesc> hashPropsProvided, List<IndexedPropDesc> rangePropsProvided) {
        IndexedPropDesc[] rangePropIndexedList;
        IndexedPropDesc[] hashPropIndexedList;
        for (IndexedPropDesc hashPropIndexed : hashPropIndexedList = indexDesc.getHashIndexedProps()) {
            boolean foundHashProp = EventTableIndexUtil.indexHashIsProvided(hashPropIndexed, hashPropsProvided);
            if (foundHashProp) continue;
            return false;
        }
        for (IndexedPropDesc rangePropIndexed : rangePropIndexedList = indexDesc.getRangeIndexedProps()) {
            boolean foundRangeProp = EventTableIndexUtil.indexHashIsProvided(rangePropIndexed, rangePropsProvided);
            if (foundRangeProp) continue;
            return false;
        }
        return true;
    }

    private static Pair<IndexMultiKey, EventTableIndexEntryBase> getPair(Map<IndexMultiKey, ? extends EventTableIndexEntryBase> tableIndexesRefCount, IndexMultiKey indexMultiKey) {
        EventTableIndexEntryBase indexFound = tableIndexesRefCount.get(indexMultiKey);
        return new Pair<IndexMultiKey, EventTableIndexEntryBase>(indexMultiKey, indexFound);
    }

    private static class IndexComparatorShortestPath
    implements Comparator<IndexMultiKey>,
    Serializable {
        private static final long serialVersionUID = -2214412607714095566L;

        private IndexComparatorShortestPath() {
        }

        @Override
        public int compare(IndexMultiKey o1, IndexMultiKey o2) {
            String[] indexedProps2;
            String[] indexedProps1 = IndexedPropDesc.getIndexProperties(o1.getHashIndexedProps());
            if (indexedProps1.length > (indexedProps2 = IndexedPropDesc.getIndexProperties(o2.getHashIndexedProps())).length) {
                return 1;
            }
            if (indexedProps1.length == indexedProps2.length) {
                return 0;
            }
            return -1;
        }
    }
}

