/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.namedwindow.consume;

import com.espertech.esper.common.internal.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerLatch;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerLatchFactory;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerView;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowDeltaData;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedWindowConsumerLatchWait
extends NamedWindowConsumerLatch {
    private static final Logger log = LoggerFactory.getLogger(NamedWindowConsumerLatchWait.class);
    private final NamedWindowConsumerLatchFactory factory;
    private NamedWindowConsumerLatchWait earlier;
    private NamedWindowConsumerLatchWait later;
    private volatile boolean isCompleted;

    public NamedWindowConsumerLatchWait(NamedWindowDeltaData deltaData, Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> dispatchTo, NamedWindowConsumerLatchFactory factory, NamedWindowConsumerLatchWait earlier) {
        super(deltaData, dispatchTo);
        this.factory = factory;
        this.earlier = earlier;
    }

    public NamedWindowConsumerLatchWait(NamedWindowConsumerLatchFactory factory) {
        super(null, null);
        this.factory = factory;
        this.isCompleted = true;
        this.earlier = null;
    }

    @Override
    public NamedWindowConsumerLatchWait getEarlier() {
        return this.earlier;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setLater(NamedWindowConsumerLatchWait later) {
        this.later = later;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() {
        if (this.earlier.isCompleted) {
            return;
        }
        NamedWindowConsumerLatchWait namedWindowConsumerLatchWait = this;
        synchronized (namedWindowConsumerLatchWait) {
            if (!this.earlier.isCompleted) {
                try {
                    this.wait(this.factory.getMsecWait());
                }
                catch (InterruptedException e) {
                    log.error("Interrupted: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (!this.earlier.isCompleted) {
            log.info("Wait timeout exceeded for named window '' consumer dispatch with notify");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() {
        this.isCompleted = true;
        if (this.later != null) {
            NamedWindowConsumerLatchWait namedWindowConsumerLatchWait = this.later;
            synchronized (namedWindowConsumerLatchWait) {
                this.later.notify();
            }
        }
        this.earlier = null;
        this.later = null;
    }
}

