/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.namedwindow.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.AuditEnum;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowEventConsumerAdd;
import com.espertech.esper.common.client.hook.vdw.VirtualDataWindowEventConsumerRemove;
import com.espertech.esper.common.internal.collection.ArrayEventIterator;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityEvaluate;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraph;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerCallback;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerDesc;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerLatchFactory;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowConsumerView;
import com.espertech.esper.common.internal.epl.namedwindow.consume.NamedWindowDeltaData;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindow;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowInstance;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowRootViewInstance;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowTailView;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowUtil;
import com.espertech.esper.common.internal.epl.updatehelper.EventBeanUpdateHelperWCopy;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWView;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class NamedWindowTailViewInstance
extends ViewSupport
implements Iterable<EventBean> {
    private final NamedWindowRootViewInstance rootViewInstance;
    private final NamedWindowTailView tailView;
    private final NamedWindow namedWindow;
    private final AgentInstanceContext agentInstanceContext;
    private final NamedWindowConsumerLatchFactory latchFactory;
    private volatile Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> consumersInContext;
    private volatile long numberOfEvents;

    public NamedWindowTailViewInstance(NamedWindowRootViewInstance rootViewInstance, NamedWindowTailView tailView, NamedWindow namedWindow, AgentInstanceContext agentInstanceContext) {
        this.rootViewInstance = rootViewInstance;
        this.tailView = tailView;
        this.namedWindow = namedWindow;
        this.agentInstanceContext = agentInstanceContext;
        this.consumersInContext = NamedWindowUtil.createConsumerMap(tailView.isPrioritized());
        this.latchFactory = tailView.makeLatchFactory();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (oldData != null) {
            this.rootViewInstance.removeOldData(oldData);
            this.numberOfEvents -= (long)oldData.length;
        }
        if (newData != null && !this.tailView.isParentBatchWindow()) {
            this.rootViewInstance.addNewData(newData);
        }
        if (newData != null) {
            this.numberOfEvents += (long)newData.length;
        }
        if (this.tailView.getStatementResultService().isMakeNatural() || this.tailView.getStatementResultService().isMakeSynthetic()) {
            this.child.update(newData, oldData);
        }
        NamedWindowDeltaData delta = new NamedWindowDeltaData(newData, oldData);
        this.tailView.addDispatches(this.latchFactory, this.consumersInContext, delta, this.agentInstanceContext);
    }

    public NamedWindowConsumerView addConsumer(NamedWindowConsumerDesc consumerDesc, boolean isSubselect) {
        List<NamedWindowConsumerView> viewsPerStatements;
        NamedWindowConsumerCallback consumerCallback = new NamedWindowConsumerCallback(){

            @Override
            public Iterator<EventBean> getIterator() {
                NamedWindowInstance instance = NamedWindowTailViewInstance.this.namedWindow.getNamedWindowInstance(NamedWindowTailViewInstance.this.agentInstanceContext);
                if (instance == null) {
                    return NamedWindowTailViewInstance.this.iterator();
                }
                return instance.getTailViewInstance().iterator();
            }

            @Override
            public void stopped(NamedWindowConsumerView namedWindowConsumerView) {
                NamedWindowTailViewInstance.this.removeConsumer(namedWindowConsumerView);
            }

            @Override
            public boolean isParentBatchWindow() {
                return NamedWindowTailViewInstance.this.rootViewInstance.isParentBatchWindow();
            }

            @Override
            public Collection<EventBean> snapshot(QueryGraph queryGraph, Annotation[] annotations) {
                return NamedWindowTailViewInstance.this.snapshot(queryGraph, annotations);
            }
        };
        boolean audit = AuditEnum.STREAM.getAudit(consumerDesc.getAgentInstanceContext().getStatementContext().getAnnotations()) != null;
        NamedWindowConsumerView consumerView = new NamedWindowConsumerView(consumerDesc.getNamedWindowConsumerId(), consumerDesc.getFilterEvaluator(), consumerDesc.getOptPropertyEvaluator(), this.tailView.getEventType(), consumerCallback, consumerDesc.getAgentInstanceContext(), audit);
        VirtualDWView virtualDWView = this.rootViewInstance.getVirtualDataWindow();
        if (virtualDWView != null) {
            virtualDWView.getVirtualDataWindow().handleEvent(new VirtualDataWindowEventConsumerAdd(this.tailView.getEventType().getName(), consumerView, consumerDesc.getAgentInstanceContext().getStatementName(), consumerDesc.getAgentInstanceContext().getAgentInstanceId(), consumerDesc.getFilterEvaluator(), this.agentInstanceContext));
        }
        if ((viewsPerStatements = this.consumersInContext.get(consumerDesc.getAgentInstanceContext().getEpStatementAgentInstanceHandle())) == null) {
            viewsPerStatements = new CopyOnWriteArrayList<NamedWindowConsumerView>();
            Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> newConsumers = NamedWindowUtil.createConsumerMap(this.tailView.isPrioritized());
            newConsumers.putAll(this.consumersInContext);
            newConsumers.put(consumerDesc.getAgentInstanceContext().getEpStatementAgentInstanceHandle(), viewsPerStatements);
            this.consumersInContext = newConsumers;
        }
        if (isSubselect) {
            viewsPerStatements.add(0, consumerView);
        } else {
            viewsPerStatements.add(consumerView);
        }
        return consumerView;
    }

    public void removeConsumer(NamedWindowConsumerView namedWindowConsumerView) {
        VirtualDWView virtualDWView;
        EPStatementAgentInstanceHandle handleRemoved = null;
        for (Map.Entry<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> entry : this.consumersInContext.entrySet()) {
            boolean foundAndRemoved = entry.getValue().remove(namedWindowConsumerView);
            if (!foundAndRemoved || entry.getValue().size() != 0) continue;
            handleRemoved = entry.getKey();
            break;
        }
        if (handleRemoved != null) {
            Map<EPStatementAgentInstanceHandle, List<NamedWindowConsumerView>> newConsumers = NamedWindowUtil.createConsumerMap(this.tailView.isPrioritized());
            newConsumers.putAll(this.consumersInContext);
            newConsumers.remove(handleRemoved);
            this.consumersInContext = newConsumers;
        }
        if ((virtualDWView = this.rootViewInstance.getVirtualDataWindow()) != null && handleRemoved != null) {
            virtualDWView.getVirtualDataWindow().handleEvent(new VirtualDataWindowEventConsumerRemove(this.tailView.getEventType().getName(), namedWindowConsumerView, handleRemoved.getStatementHandle().getStatementName(), handleRemoved.getAgentInstanceId()));
        }
    }

    @Override
    public EventType getEventType() {
        return this.tailView.getEventType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<EventBean> iterator() {
        this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().acquireReadLock();
        try {
            Iterator<EventBean> it = this.parent.iterator();
            if (!it.hasNext()) {
                Iterator<EventBean> iterator = CollectionUtil.NULL_EVENT_ITERATOR;
                return iterator;
            }
            ArrayList<EventBean> list = new ArrayList<EventBean>();
            while (it.hasNext()) {
                list.add(it.next());
            }
            ArrayEventIterator arrayEventIterator = new ArrayEventIterator(list.toArray(new EventBean[list.size()]));
            return arrayEventIterator;
        }
        finally {
            this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<EventBean> snapshot(QueryGraph queryGraph, Annotation[] annotations) {
        this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().acquireReadLock();
        try {
            Collection<EventBean> collection = this.snapshotNoLock(queryGraph, annotations);
            return collection;
        }
        finally {
            this.releaseTableLocks(this.agentInstanceContext);
            this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventBean[] snapshotUpdate(QueryGraph filterQueryGraph, ExprEvaluator optionalWhereClause, EventBeanUpdateHelperWCopy updateHelper, Annotation[] annotations) {
        this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().acquireWriteLock();
        try {
            Collection<EventBean> events = this.snapshotNoLockWithFilter(filterQueryGraph, annotations, optionalWhereClause, this.agentInstanceContext);
            if (events.isEmpty()) {
                EventBean[] eventBeanArray = CollectionUtil.EVENTBEANARRAY_EMPTY;
                return eventBeanArray;
            }
            EventBean[] eventsPerStream = new EventBean[3];
            EventBean[] updated = new EventBean[events.size()];
            int count = 0;
            for (EventBean event : events) {
                updated[count++] = updateHelper.updateWCopy(event, eventsPerStream, this.agentInstanceContext);
            }
            EventBean[] deleted = events.toArray(new EventBean[events.size()]);
            this.rootViewInstance.update(updated, deleted);
            EventBean[] eventBeanArray = updated;
            return eventBeanArray;
        }
        finally {
            this.releaseTableLocks(this.agentInstanceContext);
            this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventBean[] snapshotDelete(QueryGraph filterQueryGraph, ExprEvaluator filterExpr, Annotation[] annotations) {
        this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().acquireWriteLock();
        try {
            Collection<EventBean> events = this.snapshotNoLockWithFilter(filterQueryGraph, annotations, filterExpr, this.agentInstanceContext);
            if (events.isEmpty()) {
                EventBean[] eventBeanArray = CollectionUtil.EVENTBEANARRAY_EMPTY;
                return eventBeanArray;
            }
            EventBean[] eventsDeleted = events.toArray(new EventBean[events.size()]);
            this.rootViewInstance.update(null, eventsDeleted);
            EventBean[] eventBeanArray = eventsDeleted;
            return eventBeanArray;
        }
        finally {
            this.releaseTableLocks(this.agentInstanceContext);
            this.agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock().releaseWriteLock();
        }
    }

    public Collection<EventBean> snapshotNoLock(QueryGraph queryGraph, Annotation[] annotations) {
        Collection<EventBean> indexedResult = this.rootViewInstance.snapshot(queryGraph, annotations);
        if (indexedResult != null) {
            return indexedResult;
        }
        Iterator<EventBean> it = this.parent.iterator();
        if (!it.hasNext()) {
            return Collections.EMPTY_LIST;
        }
        ArrayDeque<EventBean> list = new ArrayDeque<EventBean>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public Collection<EventBean> snapshotNoLockWithFilter(QueryGraph filterQueryGraph, Annotation[] annotations, ExprEvaluator filterExpr, ExprEvaluatorContext exprEvaluatorContext) {
        Collection<EventBean> indexedResult = this.rootViewInstance.snapshot(filterQueryGraph, annotations);
        if (indexedResult != null) {
            if (indexedResult.isEmpty()) {
                return indexedResult;
            }
            if (filterExpr == null) {
                return indexedResult;
            }
            ArrayDeque<EventBean> deque = new ArrayDeque<EventBean>(Math.min(indexedResult.size(), 16));
            ExprNodeUtilityEvaluate.applyFilterExpressionIterable(indexedResult.iterator(), filterExpr, exprEvaluatorContext, deque);
            return deque;
        }
        Iterator<EventBean> it = this.parent.iterator();
        if (!it.hasNext()) {
            return Collections.EMPTY_LIST;
        }
        ArrayDeque<EventBean> list = new ArrayDeque<EventBean>();
        if (filterExpr != null) {
            ExprNodeUtilityEvaluate.applyFilterExpressionIterable(it, filterExpr, this.agentInstanceContext, list);
        } else {
            while (it.hasNext()) {
                list.add(it.next());
            }
        }
        return list;
    }

    public AgentInstanceContext getAgentInstanceContext() {
        return this.agentInstanceContext;
    }

    public void destroy() {
        this.consumersInContext = NamedWindowUtil.createConsumerMap(this.tailView.isPrioritized());
    }

    public long getNumberOfEvents() {
        return this.numberOfEvents;
    }

    public NamedWindowTailView getTailView() {
        return this.tailView;
    }

    private void releaseTableLocks(AgentInstanceContext agentInstanceContext) {
        agentInstanceContext.getTableExprEvaluatorContext().releaseAcquiredLocks();
    }

    public void stop() {
    }
}

