/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.ontrigger;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.OneEventCollection;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.StatementResultService;
import com.espertech.esper.common.internal.epl.lookupplansubord.SubordWMatchExprLookupStrategy;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowRootViewInstance;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnMergeMatch;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnMergeViewFactory;
import com.espertech.esper.common.internal.epl.ontrigger.OnExprViewNameWindowBase;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import com.espertech.esper.common.internal.metrics.stmtmetrics.StatementMetricHandle;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import java.util.Iterator;
import java.util.List;

public class OnExprViewNamedWindowMerge
extends OnExprViewNameWindowBase {
    private final InfraOnMergeViewFactory parent;

    public OnExprViewNamedWindowMerge(SubordWMatchExprLookupStrategy lookupStrategy, NamedWindowRootViewInstance rootView, AgentInstanceContext agentInstanceContext, InfraOnMergeViewFactory parent) {
        super(lookupStrategy, rootView, agentInstanceContext);
        this.parent = parent;
    }

    @Override
    public void handleMatching(EventBean[] triggerEvents, EventBean[] matchingEvents) {
        InstrumentationCommon instrumentationCommon = this.agentInstanceContext.getInstrumentationProvider();
        instrumentationCommon.qInfraOnAction(OnTriggerType.ON_MERGE, triggerEvents, matchingEvents);
        OneEventCollection newData = new OneEventCollection();
        OneEventCollection oldData = null;
        EventBean[] eventsPerStream = new EventBean[3];
        if (matchingEvents == null || matchingEvents.length == 0) {
            List<InfraOnMergeMatch> unmatched = this.parent.getOnMergeHelper().getUnmatched();
            EventBean[] eventBeanArray = triggerEvents;
            int n = eventBeanArray.length;
            for (int i = 0; i < n; ++i) {
                EventBean triggerEvent;
                eventsPerStream[1] = triggerEvent = eventBeanArray[i];
                instrumentationCommon.qInfraMergeWhenThens(false, triggerEvent, unmatched.size());
                int count = -1;
                for (InfraOnMergeMatch action : unmatched) {
                    instrumentationCommon.qInfraMergeWhenThenItem(false, ++count);
                    if (!action.isApplies(eventsPerStream, super.getExprEvaluatorContext())) {
                        instrumentationCommon.aInfraMergeWhenThenItem(false, false);
                        continue;
                    }
                    action.applyNamedWindow(null, eventsPerStream, newData, oldData, this.agentInstanceContext);
                    instrumentationCommon.aInfraMergeWhenThenItem(false, true);
                    break;
                }
                instrumentationCommon.aInfraMergeWhenThens(false);
            }
        } else {
            oldData = new OneEventCollection();
            List<InfraOnMergeMatch> matched = this.parent.getOnMergeHelper().getMatched();
            EventBean[] eventBeanArray = triggerEvents;
            int n = eventBeanArray.length;
            for (int i = 0; i < n; ++i) {
                EventBean triggerEvent;
                eventsPerStream[1] = triggerEvent = eventBeanArray[i];
                instrumentationCommon.qInfraMergeWhenThens(true, triggerEvent, matched.size());
                EventBean[] eventBeanArray2 = matchingEvents;
                int n2 = eventBeanArray2.length;
                block3: for (int j = 0; j < n2; ++j) {
                    EventBean matchingEvent;
                    eventsPerStream[0] = matchingEvent = eventBeanArray2[j];
                    int count = -1;
                    for (InfraOnMergeMatch action : matched) {
                        instrumentationCommon.qInfraMergeWhenThenItem(true, ++count);
                        if (!action.isApplies(eventsPerStream, super.getExprEvaluatorContext())) {
                            instrumentationCommon.aInfraMergeWhenThenItem(true, false);
                            continue;
                        }
                        action.applyNamedWindow(matchingEvent, eventsPerStream, newData, oldData, this.agentInstanceContext);
                        instrumentationCommon.aInfraMergeWhenThenItem(true, true);
                        continue block3;
                    }
                }
                instrumentationCommon.aInfraMergeWhenThens(true);
            }
        }
        OnExprViewNamedWindowMerge.applyDelta(newData, oldData, this.parent, this.rootView, this.agentInstanceContext, this);
        instrumentationCommon.aInfraOnAction();
    }

    static void applyDelta(OneEventCollection newData, OneEventCollection oldData, InfraOnMergeViewFactory parent, NamedWindowRootViewInstance rootView, AgentInstanceContext agentInstanceContext, ViewSupport viewable) {
        if (!newData.isEmpty() || oldData != null && !oldData.isEmpty()) {
            StatementResultService statementResultService;
            StatementMetricHandle metricHandle = rootView.getAgentInstanceContext().getStatementContext().getEpStatementHandle().getMetricsHandle();
            if (metricHandle.isEnabled() && !newData.isEmpty()) {
                agentInstanceContext.getMetricReportingService().accountTime(metricHandle, 0L, 0L, newData.toArray().length);
            }
            if ((statementResultService = agentInstanceContext.getStatementResultService()).isMakeNatural()) {
                EventBean[] eventsPerStreamNaturalNew = newData.isEmpty() ? null : newData.toArray();
                EventBean[] eventsPerStreamNaturalOld = oldData == null || oldData.isEmpty() ? null : oldData.toArray();
                rootView.update(EventBeanUtility.denaturalize(eventsPerStreamNaturalNew), EventBeanUtility.denaturalize(eventsPerStreamNaturalOld));
                viewable.getChild().update(eventsPerStreamNaturalNew, eventsPerStreamNaturalOld);
            } else {
                EventBean[] eventsPerStreamNew = newData.isEmpty() ? null : newData.toArray();
                EventBean[] eventsPerStreamOld = oldData == null || oldData.isEmpty() ? null : oldData.toArray();
                rootView.update(eventsPerStreamNew, eventsPerStreamOld);
                if (statementResultService.isMakeSynthetic()) {
                    viewable.getChild().update(eventsPerStreamNew, eventsPerStreamOld);
                }
            }
        }
    }

    @Override
    public EventType getEventType() {
        return this.rootView.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return CollectionUtil.NULL_EVENT_ITERATOR;
    }
}

