/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.ontrigger;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.lookupplansubord.SubordWMatchExprLookupStrategy;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.StopCallback;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OnExprViewTableBase
extends ViewSupport
implements StopCallback {
    private static final Logger log = LoggerFactory.getLogger(OnExprViewTableBase.class);
    protected final SubordWMatchExprLookupStrategy lookupStrategy;
    protected final TableInstance tableInstance;
    protected final AgentInstanceContext agentInstanceContext;
    protected final boolean acquireWriteLock;

    protected OnExprViewTableBase(SubordWMatchExprLookupStrategy lookupStrategy, TableInstance tableInstance, AgentInstanceContext agentInstanceContext, boolean acquireWriteLock) {
        this.lookupStrategy = lookupStrategy;
        this.tableInstance = tableInstance;
        this.agentInstanceContext = agentInstanceContext;
        this.acquireWriteLock = acquireWriteLock;
    }

    public abstract void handleMatching(EventBean[] var1, EventBean[] var2);

    @Override
    public void stop() {
        log.debug(".stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (newData == null) {
            return;
        }
        if (this.acquireWriteLock) {
            this.tableInstance.getTableLevelRWLock().writeLock().lock();
            try {
                this.processLocked(newData);
            }
            finally {
                this.tableInstance.getTableLevelRWLock().writeLock().unlock();
            }
        }
        this.tableInstance.getTableLevelRWLock().readLock().lock();
        try {
            this.processLocked(newData);
        }
        finally {
            this.tableInstance.getTableLevelRWLock().readLock().unlock();
        }
    }

    public ExprEvaluatorContext getExprEvaluatorContext() {
        return this.agentInstanceContext;
    }

    @Override
    public Iterator<EventBean> iterator() {
        return CollectionUtil.NULL_EVENT_ITERATOR;
    }

    @Override
    public EventType getEventType() {
        return this.tableInstance.getTable().getMetaData().getPublicEventType();
    }

    private void processLocked(EventBean[] newData) {
        if (newData.length == 1) {
            this.process(newData);
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] eventBeanArray = newData;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean event;
            eventsPerStream[0] = event = eventBeanArray[i];
            this.process(eventsPerStream);
        }
    }

    private void process(EventBean[] events) {
        EventBean[] eventsFound = this.lookupStrategy.lookup(events, this.agentInstanceContext);
        this.handleMatching(events, eventsFound);
    }
}

