/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.condition;

import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodDeltaResult;
import com.espertech.esper.common.internal.epl.output.condition.OutputCallback;
import com.espertech.esper.common.internal.epl.output.condition.OutputCondition;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionBase;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionTimeFactory;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.util.ExecutionPathDebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutputConditionTime
extends OutputConditionBase
implements OutputCondition {
    public static final String NAME_AUDITPROVIDER_SCHEDULE = "time";
    private static final boolean DO_OUTPUT = true;
    private static final boolean FORCE_UPDATE = true;
    private final AgentInstanceContext context;
    private final OutputConditionTimeFactory parent;
    private final long scheduleSlot;
    private Long currentReferencePoint;
    private boolean isCallbackScheduled;
    private EPStatementHandleCallbackSchedule handle;
    private long currentScheduledTime;
    private static final Logger log = LoggerFactory.getLogger(OutputConditionTime.class);

    public OutputConditionTime(OutputCallback outputCallback, AgentInstanceContext context, OutputConditionTimeFactory outputConditionTimeFactory, boolean isStartConditionOnCreation) {
        super(outputCallback);
        this.context = context;
        this.parent = outputConditionTimeFactory;
        this.scheduleSlot = context.getStatementContext().getScheduleBucket().allocateSlot();
        if (isStartConditionOnCreation) {
            this.updateOutputCondition(0, 0);
        }
    }

    @Override
    public final void updateOutputCondition(int newEventsCount, int oldEventsCount) {
        if (this.currentReferencePoint == null) {
            this.currentReferencePoint = this.context.getStatementContext().getSchedulingService().getTime();
        }
        if (this.parent.isHasVariable()) {
            long now = this.context.getStatementContext().getSchedulingService().getTime();
            TimePeriodDeltaResult delta = this.parent.getTimePeriodCompute().deltaAddWReference(now, this.currentReferencePoint, null, true, this.context);
            if (delta.getDelta() != this.currentScheduledTime && this.isCallbackScheduled) {
                this.context.getAuditProvider().scheduleRemove(this.context, this.handle, ScheduleObjectType.outputratelimiting, NAME_AUDITPROVIDER_SCHEDULE);
                this.context.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
                this.scheduleCallback();
            }
        }
        if (!this.isCallbackScheduled) {
            this.scheduleCallback();
        }
    }

    public final String toString() {
        return this.getClass().getName();
    }

    private void scheduleCallback() {
        this.isCallbackScheduled = true;
        long current = this.context.getStatementContext().getSchedulingService().getTime();
        TimePeriodDeltaResult delta = this.parent.getTimePeriodCompute().deltaAddWReference(current, this.currentReferencePoint, null, true, this.context);
        long deltaTime = delta.getDelta();
        this.currentReferencePoint = delta.getLastReference();
        this.currentScheduledTime = deltaTime;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".scheduleCallback Scheduled new callback for  afterMsec=" + deltaTime + " now=" + current + " currentReferencePoint=" + this.currentReferencePoint);
        }
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger() {
                OutputConditionTime.this.context.getInstrumentationProvider().qOutputRateConditionScheduledEval();
                OutputConditionTime.this.context.getAuditProvider().scheduleFire(OutputConditionTime.this.context, ScheduleObjectType.outputratelimiting, OutputConditionTime.NAME_AUDITPROVIDER_SCHEDULE);
                OutputConditionTime.this.isCallbackScheduled = false;
                OutputConditionTime.this.outputCallback.continueOutputProcessing(true, true);
                OutputConditionTime.this.scheduleCallback();
                OutputConditionTime.this.context.getInstrumentationProvider().aOutputRateConditionScheduledEval();
            }
        };
        this.handle = new EPStatementHandleCallbackSchedule(this.context.getEpStatementAgentInstanceHandle(), callback);
        this.context.getAuditProvider().scheduleAdd(deltaTime, this.context, this.handle, ScheduleObjectType.outputratelimiting, NAME_AUDITPROVIDER_SCHEDULE);
        this.context.getStatementContext().getSchedulingService().add(deltaTime, this.handle, this.scheduleSlot);
    }

    @Override
    public void stopOutputCondition() {
        if (this.handle != null) {
            this.context.getAuditProvider().scheduleRemove(this.context, this.handle, ScheduleObjectType.outputratelimiting, NAME_AUDITPROVIDER_SCHEDULE);
            this.context.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }
}

