/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.StatementResultService;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.output.condition.OutputCondition;
import com.espertech.esper.common.internal.epl.output.core.OutputProcessView;
import com.espertech.esper.common.internal.epl.output.core.OutputStrategyUtil;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import java.util.Iterator;
import java.util.Set;

public class OutputProcessViewDirectSimpleImpl
extends OutputProcessView {
    private final ResultSetProcessor resultSetProcessor;
    private final AgentInstanceContext agentInstanceContext;

    public OutputProcessViewDirectSimpleImpl(ResultSetProcessor resultSetProcessor, AgentInstanceContext agentInstanceContext) {
        this.resultSetProcessor = resultSetProcessor;
        this.agentInstanceContext = agentInstanceContext;
    }

    @Override
    public EventType getEventType() {
        return this.resultSetProcessor.getResultEventType();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        InstrumentationCommon instrumentationCommon = this.agentInstanceContext.getInstrumentationProvider();
        instrumentationCommon.qOutputProcessNonBuffered(newData, oldData);
        StatementResultService statementResultService = this.agentInstanceContext.getStatementResultService();
        boolean isGenerateSynthetic = statementResultService.isMakeSynthetic();
        boolean isGenerateNatural = statementResultService.isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processViewResult(newData, oldData, isGenerateSynthetic);
        if (!isGenerateSynthetic && !isGenerateNatural) {
            return;
        }
        if (this.child != null) {
            if (newOldEvents != null) {
                if (newOldEvents.getFirst() != null || newOldEvents.getSecond() != null) {
                    this.child.newResult(newOldEvents);
                } else if (newData == null && oldData == null) {
                    this.child.newResult(newOldEvents);
                }
            } else if (newData == null && oldData == null) {
                this.child.newResult(newOldEvents);
            }
        }
        instrumentationCommon.aOutputProcessNonBuffered();
    }

    @Override
    public void process(Set<MultiKeyArrayOfKeys<EventBean>> newData, Set<MultiKeyArrayOfKeys<EventBean>> oldData, ExprEvaluatorContext exprEvaluatorContext) {
        InstrumentationCommon instrumentationCommon = this.agentInstanceContext.getInstrumentationProvider();
        instrumentationCommon.qOutputProcessNonBufferedJoin(newData, oldData);
        StatementResultService statementResultService = this.agentInstanceContext.getStatementResultService();
        boolean isGenerateSynthetic = statementResultService.isMakeSynthetic();
        boolean isGenerateNatural = statementResultService.isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processJoinResult(newData, oldData, isGenerateSynthetic);
        if (!isGenerateSynthetic && !isGenerateNatural) {
            return;
        }
        if (newOldEvents == null) {
            return;
        }
        if (newOldEvents.getFirst() != null || newOldEvents.getSecond() != null) {
            this.child.newResult(newOldEvents);
        } else if (newData == null && oldData == null) {
            this.child.newResult(newOldEvents);
        }
        instrumentationCommon.aOutputProcessNonBufferedJoin();
    }

    @Override
    public Iterator iterator() {
        return OutputStrategyUtil.getIterator(this.joinExecutionStrategy, this.resultSetProcessor, this.parentView, false, null);
    }

    @Override
    public int getNumChangesetRows() {
        return 0;
    }

    @Override
    public OutputCondition getOptionalOutputCondition() {
        return null;
    }

    @Override
    public void stop(AgentInstanceStopServices svc) {
    }

    @Override
    public void terminated() {
    }
}

