/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.polled;

import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolled;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledCrontabState;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledState;
import com.espertech.esper.common.internal.schedule.ScheduleComputeHelper;
import com.espertech.esper.common.internal.util.ExecutionPathDebugLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutputConditionPolledCrontab
implements OutputConditionPolled {
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final OutputConditionPolledCrontabState state;
    private static final Logger log = LoggerFactory.getLogger(OutputConditionPolledCrontab.class);

    public OutputConditionPolledCrontab(ExprEvaluatorContext exprEvaluatorContext, OutputConditionPolledCrontabState state) {
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.state = state;
    }

    @Override
    public OutputConditionPolledState getState() {
        return this.state;
    }

    @Override
    public final boolean updateOutputCondition(int newEventsCount, int oldEventsCount) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".updateOutputCondition,   newEventsCount==" + newEventsCount + "  oldEventsCount==" + oldEventsCount);
        }
        boolean output = false;
        long currentTime = this.exprEvaluatorContext.getTimeProvider().getTime();
        if (this.state.getCurrentReferencePoint() == null) {
            this.state.setCurrentReferencePoint(currentTime);
            this.state.setNextScheduledTime(ScheduleComputeHelper.computeNextOccurance(this.state.getScheduleSpec(), currentTime, this.exprEvaluatorContext.getTimeZone(), this.exprEvaluatorContext.getTimeAbacus()));
            output = true;
        }
        if (this.state.getNextScheduledTime() <= currentTime) {
            this.state.setNextScheduledTime(ScheduleComputeHelper.computeNextOccurance(this.state.getScheduleSpec(), currentTime, this.exprEvaluatorContext.getTimeZone(), this.exprEvaluatorContext.getTimeAbacus()));
            output = true;
        }
        return output;
    }
}

