/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.polled;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionExpressionTypeUtil;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolled;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledExpressionFactory;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledExpressionState;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledState;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBean;

public class OutputConditionPolledExpression
implements OutputConditionPolled {
    private final OutputConditionPolledExpressionFactory factory;
    private final OutputConditionPolledExpressionState state;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private ObjectArrayEventBean builtinProperties;
    private EventBean[] eventsPerStream = new EventBean[1];

    public OutputConditionPolledExpression(OutputConditionPolledExpressionFactory factory, OutputConditionPolledExpressionState state, ExprEvaluatorContext exprEvaluatorContext, ObjectArrayEventBean builtinProperties) {
        this.factory = factory;
        this.state = state;
        this.builtinProperties = builtinProperties;
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public OutputConditionPolledState getState() {
        return this.state;
    }

    @Override
    public boolean updateOutputCondition(int newEventsCount, int oldEventsCount) {
        this.state.setTotalNewEventsCount(this.state.getTotalNewEventsCount() + newEventsCount);
        this.state.setTotalOldEventsCount(this.state.getTotalOldEventsCount() + oldEventsCount);
        this.state.setTotalNewEventsSum(this.state.getTotalNewEventsSum() + newEventsCount);
        this.state.setTotalOldEventsSum(this.state.getTotalOldEventsCount() + oldEventsCount);
        boolean isOutput = this.evaluate();
        if (isOutput) {
            this.resetBuiltinProperties();
            if (this.factory.getVariableReadWritePackage() != null) {
                if (this.builtinProperties != null) {
                    this.populateBuiltinProperties();
                    this.eventsPerStream[0] = this.builtinProperties;
                }
                this.factory.getVariableReadWritePackage().writeVariables(this.eventsPerStream, null, this.exprEvaluatorContext);
            }
        }
        return isOutput;
    }

    private void populateBuiltinProperties() {
        OutputConditionExpressionTypeUtil.populate(this.builtinProperties.getProperties(), this.state.getTotalNewEventsCount(), this.state.getTotalOldEventsCount(), this.state.getTotalNewEventsSum(), this.state.getTotalOldEventsSum(), this.state.getLastOutputTimestamp());
    }

    private boolean evaluate() {
        if (this.builtinProperties != null) {
            this.populateBuiltinProperties();
            this.eventsPerStream[0] = this.builtinProperties;
        }
        boolean result = false;
        Boolean output = (Boolean)this.factory.getWhenExpression().evaluate(this.eventsPerStream, true, this.exprEvaluatorContext);
        if (output != null && output.booleanValue()) {
            result = true;
        }
        return result;
    }

    private void resetBuiltinProperties() {
        if (this.builtinProperties != null) {
            this.state.setTotalNewEventsCount(0);
            this.state.setTotalOldEventsCount(0);
            this.state.setLastOutputTimestamp(this.exprEvaluatorContext.getTimeProvider().getTime());
        }
    }
}

