/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.polled;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.output.condition.OutputConditionExpressionTypeUtil;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolled;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledExpression;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledExpressionState;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledFactory;
import com.espertech.esper.common.internal.epl.output.polled.OutputConditionPolledState;
import com.espertech.esper.common.internal.epl.variable.core.VariableReadWritePackage;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBean;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactoryDisallow;

public class OutputConditionPolledExpressionFactory
implements OutputConditionPolledFactory {
    public static final EPTypeClass EPTYPE = new EPTypeClass(OutputConditionPolledExpressionFactory.class);
    private ExprEvaluator whenExpression;
    private VariableReadWritePackage variableReadWritePackage;
    private boolean isUsingBuiltinProperties;
    private EventType builtinPropertiesEventType;

    public void setWhenExpression(ExprEvaluator whenExpression) {
        this.whenExpression = whenExpression;
    }

    public void setVariableReadWritePackage(VariableReadWritePackage variableReadWritePackage) {
        this.variableReadWritePackage = variableReadWritePackage;
    }

    public void setUsingBuiltinProperties(boolean usingBuiltinProperties) {
        this.isUsingBuiltinProperties = usingBuiltinProperties;
    }

    @Override
    public OutputConditionPolled makeFromState(ExprEvaluatorContext exprEvaluatorContext, OutputConditionPolledState state) {
        ObjectArrayEventBean builtinProperties = null;
        if (this.isUsingBuiltinProperties) {
            this.initType(exprEvaluatorContext);
            builtinProperties = new ObjectArrayEventBean(OutputConditionExpressionTypeUtil.getOAPrototype(), this.builtinPropertiesEventType);
        }
        OutputConditionPolledExpressionState expressionState = (OutputConditionPolledExpressionState)state;
        return new OutputConditionPolledExpression(this, expressionState, exprEvaluatorContext, builtinProperties);
    }

    @Override
    public OutputConditionPolled makeNew(ExprEvaluatorContext exprEvaluatorContext) {
        ObjectArrayEventBean builtinProperties = null;
        Long lastOutputTimestamp = null;
        if (this.isUsingBuiltinProperties) {
            this.initType(exprEvaluatorContext);
            builtinProperties = new ObjectArrayEventBean(OutputConditionExpressionTypeUtil.getOAPrototype(), this.builtinPropertiesEventType);
            lastOutputTimestamp = exprEvaluatorContext.getTimeProvider().getTime();
        }
        OutputConditionPolledExpressionState state = new OutputConditionPolledExpressionState(0, 0, 0, 0, lastOutputTimestamp);
        return new OutputConditionPolledExpression(this, state, exprEvaluatorContext, builtinProperties);
    }

    public ExprEvaluator getWhenExpression() {
        return this.whenExpression;
    }

    public VariableReadWritePackage getVariableReadWritePackage() {
        return this.variableReadWritePackage;
    }

    private void initType(ExprEvaluatorContext exprEvaluatorContext) {
        if (this.builtinPropertiesEventType == null) {
            this.builtinPropertiesEventType = OutputConditionExpressionTypeUtil.getBuiltInEventType(exprEvaluatorContext.getModuleName(), new BeanEventTypeFactoryDisallow(exprEvaluatorContext.getEventBeanTypedEventFactory()));
        }
    }
}

