/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.view;

import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodCompute;
import com.espertech.esper.common.internal.epl.output.core.OutputProcessView;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewDirectDistinctOrAfter;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewDirectDistinctOrAfterPostProcess;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewDirectFactory;
import com.espertech.esper.common.internal.epl.output.view.OutputStrategyPostProcess;
import com.espertech.esper.common.internal.epl.output.view.OutputStrategyPostProcessFactory;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;

public class OutputProcessViewDirectDistinctOrAfterFactory
extends OutputProcessViewDirectFactory {
    public static final EPTypeClass EPTYPE = new EPTypeClass(OutputProcessViewDirectDistinctOrAfterFactory.class);
    private final boolean isDistinct;
    private final EventPropertyValueGetter distinctKeyGetter;
    protected final TimePeriodCompute afterTimePeriod;
    protected final Integer afterConditionNumberOfEvents;

    public OutputProcessViewDirectDistinctOrAfterFactory(OutputStrategyPostProcessFactory postProcessFactory, boolean distinct, EventPropertyValueGetter distinctKeyGetter, TimePeriodCompute afterTimePeriod, Integer afterConditionNumberOfEvents) {
        super(postProcessFactory);
        this.isDistinct = distinct;
        this.distinctKeyGetter = distinctKeyGetter;
        this.afterTimePeriod = afterTimePeriod;
        this.afterConditionNumberOfEvents = afterConditionNumberOfEvents;
    }

    @Override
    public OutputProcessView makeView(ResultSetProcessor resultSetProcessor, AgentInstanceContext agentInstanceContext) {
        boolean isAfterConditionSatisfied = true;
        Long afterConditionTime = null;
        if (this.afterConditionNumberOfEvents != null) {
            isAfterConditionSatisfied = false;
        } else if (this.afterTimePeriod != null) {
            isAfterConditionSatisfied = false;
            long time = agentInstanceContext.getTimeProvider().getTime();
            long delta = this.afterTimePeriod.deltaAdd(time, null, true, agentInstanceContext);
            afterConditionTime = time + delta;
        }
        if (this.postProcessFactory == null) {
            return new OutputProcessViewDirectDistinctOrAfter(agentInstanceContext, resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this);
        }
        OutputStrategyPostProcess postProcess = this.postProcessFactory.make(agentInstanceContext);
        return new OutputProcessViewDirectDistinctOrAfterPostProcess(agentInstanceContext, resultSetProcessor, afterConditionTime, this.afterConditionNumberOfEvents, isAfterConditionSatisfied, this, postProcess);
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public EventPropertyValueGetter getDistinctKeyGetter() {
        return this.distinctKeyGetter;
    }
}

