/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.and;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.and.EvalAndNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNodeVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.Evaluator;
import com.espertech.esper.common.internal.epl.pattern.core.PatternConsumptionUtil;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalAndStateNode
extends EvalStateNode
implements Evaluator {
    protected final EvalAndNode evalAndNode;
    protected final EvalStateNode[] activeChildNodes;
    protected Object[] eventsPerChild;
    private static final Logger log = LoggerFactory.getLogger(EvalAndStateNode.class);

    public EvalAndStateNode(Evaluator parentNode, EvalAndNode evalAndNode) {
        super(parentNode);
        this.evalAndNode = evalAndNode;
        this.activeChildNodes = new EvalStateNode[evalAndNode.getChildNodes().length];
        this.eventsPerChild = new Object[evalAndNode.getChildNodes().length];
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        boolean quit = false;
        if (this.eventsPerChild != null) {
            for (Object entry : this.eventsPerChild) {
                if (entry instanceof MatchedEventMap) {
                    quit = PatternConsumptionUtil.containsEvent(matchEvent, (MatchedEventMap)entry);
                } else if (entry != null) {
                    MatchedEventMap map;
                    List list = (List)entry;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext() && !(quit = PatternConsumptionUtil.containsEvent(matchEvent, map = (MatchedEventMap)iterator.next()))) {
                    }
                }
                if (quit) break;
            }
        }
        if (!quit && this.activeChildNodes != null) {
            for (EvalStateNode child : this.activeChildNodes) {
                if (child == null) continue;
                child.removeMatch(matchEvent);
            }
        }
        if (quit) {
            this.quit();
            AgentInstanceContext agentInstanceContext = this.evalAndNode.getContext().getAgentInstanceContext();
            agentInstanceContext.getAuditProvider().patternFalse(this.evalAndNode.getFactoryNode(), this, agentInstanceContext);
            this.getParentEvaluator().evaluateFalse(this, true);
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalAndNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        AgentInstanceContext agentInstanceContext = this.evalAndNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternAndStart(this.evalAndNode.factoryNode, beginState);
        agentInstanceContext.getAuditProvider().patternInstance(true, this.evalAndNode.factoryNode, agentInstanceContext);
        int count = 0;
        for (EvalNode node : this.evalAndNode.getChildNodes()) {
            EvalStateNode childState = node.newState(this);
            this.activeChildNodes[count++] = childState;
        }
        for (EvalStateNode child : this.activeChildNodes) {
            if (child == null) continue;
            child.start(beginState);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternAndStart();
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted, EventBean optionalTriggeringEvent) {
        AgentInstanceContext agentInstanceContext = this.evalAndNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternAndEvaluateTrue(this.evalAndNode.factoryNode, matchEvent);
        Integer indexFrom = null;
        for (int i = 0; i < this.activeChildNodes.length; ++i) {
            if (this.activeChildNodes[i] != fromNode) continue;
            indexFrom = i;
        }
        if (isQuitted && indexFrom != null) {
            this.activeChildNodes[indexFrom.intValue()] = null;
        }
        if (this.eventsPerChild == null || indexFrom == null) {
            agentInstanceContext.getInstrumentationProvider().aPatternAndEvaluateTrue(true);
            return;
        }
        boolean allHaveEventsExcludingFromChild = true;
        for (int i = 0; i < this.eventsPerChild.length; ++i) {
            if (indexFrom == i || this.eventsPerChild[i] != null) continue;
            allHaveEventsExcludingFromChild = false;
            break;
        }
        if (!allHaveEventsExcludingFromChild) {
            EvalAndStateNode.addMatchEvent(this.eventsPerChild, indexFrom, matchEvent);
            agentInstanceContext.getInstrumentationProvider().aPatternAndEvaluateTrue(false);
            return;
        }
        boolean allOtherNodesQuit = true;
        boolean hasActive = false;
        for (int i = 0; i < this.eventsPerChild.length; ++i) {
            if (this.activeChildNodes[i] == null) continue;
            hasActive = true;
            if (i == indexFrom) continue;
            allOtherNodesQuit = false;
        }
        if (!allOtherNodesQuit) {
            EvalAndStateNode.addMatchEvent(this.eventsPerChild, indexFrom, matchEvent);
        }
        List<MatchedEventMap> result = EvalAndStateNode.generateMatchEvents(matchEvent, this.eventsPerChild, indexFrom);
        boolean quitted = true;
        if (hasActive) {
            for (EvalStateNode stateNode : this.activeChildNodes) {
                if (stateNode == null || stateNode.isNotOperator()) continue;
                quitted = false;
            }
        }
        if (quitted) {
            agentInstanceContext.getAuditProvider().patternInstance(false, this.evalAndNode.factoryNode, agentInstanceContext);
            this.quitInternal();
        }
        for (MatchedEventMap theEvent : result) {
            agentInstanceContext.getAuditProvider().patternTrue(this.evalAndNode.getFactoryNode(), this, theEvent, quitted, agentInstanceContext);
            this.getParentEvaluator().evaluateTrue(theEvent, this, quitted, optionalTriggeringEvent);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternAndEvaluateTrue(quitted);
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        AgentInstanceContext agentInstanceContext = this.evalAndNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternAndEvaluateFalse(this.evalAndNode.factoryNode);
        Integer indexFrom = null;
        for (int i = 0; i < this.activeChildNodes.length; ++i) {
            if (this.activeChildNodes[i] != fromNode) continue;
            this.activeChildNodes[i] = null;
            indexFrom = i;
        }
        if (indexFrom != null) {
            this.eventsPerChild[indexFrom.intValue()] = null;
        }
        this.quitInternal();
        agentInstanceContext.getAuditProvider().patternFalse(this.evalAndNode.getFactoryNode(), this, agentInstanceContext);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.evalAndNode.factoryNode, agentInstanceContext);
        this.getParentEvaluator().evaluateFalse(this, restartable);
        agentInstanceContext.getInstrumentationProvider().aPatternAndEvaluateFalse();
    }

    public static List<MatchedEventMap> generateMatchEvents(MatchedEventMap matchEvent, Object[] eventsPerChild, int indexFrom) {
        ArrayList<List<MatchedEventMap>> listArray = new ArrayList<List<MatchedEventMap>>();
        int index = 0;
        for (int i = 0; i < eventsPerChild.length; ++i) {
            Object eventsChild = eventsPerChild[i];
            if (indexFrom == i || eventsChild == null) continue;
            if (eventsChild instanceof MatchedEventMap) {
                listArray.add(index++, Collections.singletonList((MatchedEventMap)eventsChild));
                continue;
            }
            listArray.add(index++, (List)eventsChild);
        }
        ArrayList<MatchedEventMap> results = new ArrayList<MatchedEventMap>();
        EvalAndStateNode.generateMatchEvents(listArray, 0, results, matchEvent);
        return results;
    }

    protected static void generateMatchEvents(ArrayList<List<MatchedEventMap>> eventList, int index, List<MatchedEventMap> result, MatchedEventMap matchEvent) {
        List<MatchedEventMap> events = eventList.get(index);
        for (MatchedEventMap theEvent : events) {
            MatchedEventMap current = matchEvent.shallowCopy();
            current.merge(theEvent);
            if (index + 1 == eventList.size()) {
                result.add(current);
                continue;
            }
            EvalAndStateNode.generateMatchEvents(eventList, index + 1, result, current);
        }
    }

    @Override
    public final void quit() {
        if (this.eventsPerChild == null) {
            return;
        }
        AgentInstanceContext agentInstanceContext = this.evalAndNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternAndQuit(this.evalAndNode.factoryNode);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.evalAndNode.factoryNode, agentInstanceContext);
        this.quitInternal();
        agentInstanceContext.getInstrumentationProvider().aPatternAndQuit();
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitAnd(this.evalAndNode.getFactoryNode(), this, this.eventsPerChild);
        for (EvalStateNode node : this.activeChildNodes) {
            if (node == null) continue;
            node.accept(visitor);
        }
    }

    public final String toString() {
        return "EvalAndStateNode";
    }

    public static void addMatchEvent(Object[] eventsPerChild, int indexFrom, MatchedEventMap matchEvent) {
        Object matchEventHolder = eventsPerChild[indexFrom];
        if (matchEventHolder == null) {
            eventsPerChild[indexFrom] = matchEvent;
        } else if (matchEventHolder instanceof MatchedEventMap) {
            ArrayList<MatchedEventMap> list = new ArrayList<MatchedEventMap>(4);
            list.add((MatchedEventMap)matchEventHolder);
            list.add(matchEvent);
            eventsPerChild[indexFrom] = list;
        } else {
            List list = (List)matchEventHolder;
            list.add(matchEvent);
        }
    }

    private void quitInternal() {
        for (EvalStateNode child : this.activeChildNodes) {
            if (child == null) continue;
            child.quit();
        }
        Arrays.fill(this.activeChildNodes, null);
        this.eventsPerChild = null;
    }
}

