/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.core;

import com.espertech.esper.common.client.annotation.AppliesTo;
import com.espertech.esper.common.client.annotation.AuditEnum;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecTracked;
import com.espertech.esper.common.internal.compile.util.CallbackAttribution;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNodeBase;
import com.espertech.esper.common.internal.epl.pattern.core.EvalRootFactoryNode;
import com.espertech.esper.common.internal.epl.pattern.core.PatternExpressionPrecedenceEnum;
import com.espertech.esper.common.internal.schedule.ScheduleHandleTracked;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class EvalRootForgeNode
extends EvalForgeNodeBase {
    public EvalRootForgeNode(boolean attachPatternText, EvalForgeNode childNode, Annotation[] annotations) {
        super(attachPatternText);
        this.addChildNode(childNode);
        boolean audit = AuditEnum.PATTERN.getAudit(annotations) != null || AuditEnum.PATTERNINSTANCES.getAudit(annotations) != null;
        this.assignFactoryNodeIds(audit);
    }

    @Override
    protected EPTypeClass typeOfFactory() {
        return EvalRootFactoryNode.EPTYPE;
    }

    @Override
    protected String nameOfFactory() {
        return "root";
    }

    @Override
    public AppliesTo appliesTo() {
        return AppliesTo.PATTERN_ROOT;
    }

    @Override
    protected void inlineCodegen(CodegenMethod method, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod childMake = this.getChildNodes().get(0).makeCodegen(method, symbols, classScope);
        method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("node"), "setChildNode", CodegenExpressionBuilder.localMethod(childMake, new CodegenExpression[0]));
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (!this.getChildNodes().isEmpty()) {
            this.getChildNodes().get(0).toEPL(writer, this.getPrecedence());
        }
    }

    @Override
    public PatternExpressionPrecedenceEnum getPrecedence() {
        return PatternExpressionPrecedenceEnum.MINIMUM;
    }

    @Override
    public void collectSelfFilterAndSchedule(Function<Short, CallbackAttribution> callbackAttribution, List<FilterSpecTracked> filters, List<ScheduleHandleTracked> schedules) {
    }

    public List<EvalForgeNode> collectFactories() {
        ArrayList<EvalForgeNode> factories = new ArrayList<EvalForgeNode>(8);
        for (EvalForgeNode factoryNode : this.getChildNodes()) {
            EvalRootForgeNode.collectFactoriesRecursive(factoryNode, factories);
        }
        return factories;
    }

    private static void collectFactoriesRecursive(EvalForgeNode factoryNode, List<EvalForgeNode> factories) {
        factories.add(factoryNode);
        for (EvalForgeNode childNode : factoryNode.getChildNodes()) {
            EvalRootForgeNode.collectFactoriesRecursive(childNode, factories);
        }
    }

    private void assignFactoryNodeIds(boolean audit) {
        short count = 0;
        this.setFactoryNodeId(count);
        this.setAudit(audit);
        List<EvalForgeNode> factories = this.collectFactories();
        for (EvalForgeNode factoryNode : factories) {
            count = (short)(count + 1);
            factoryNode.setFactoryNodeId(count);
            factoryNode.setAudit(audit);
        }
    }
}

