/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.core;

import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.ObjectSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.PatternGuardSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.PatternObserverSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.PluggableObjectCollection;
import com.espertech.esper.common.internal.compile.stage1.spec.PluggableObjectEntry;
import com.espertech.esper.common.internal.compile.stage1.spec.PluggableObjectType;
import com.espertech.esper.common.internal.epl.pattern.core.PatternObjectException;
import com.espertech.esper.common.internal.epl.pattern.core.PatternObjectResolutionService;
import com.espertech.esper.common.internal.epl.pattern.guard.GuardForge;
import com.espertech.esper.common.internal.epl.pattern.observer.ObserverFactory;
import com.espertech.esper.common.internal.epl.pattern.observer.ObserverForge;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternObjectResolutionServiceImpl
implements PatternObjectResolutionService {
    private static final Logger log = LoggerFactory.getLogger(PatternObjectResolutionServiceImpl.class);
    private final PluggableObjectCollection patternObjects;

    public PatternObjectResolutionServiceImpl(PluggableObjectCollection patternObjects) {
        this.patternObjects = patternObjects;
    }

    @Override
    public ObserverForge create(PatternObserverSpec spec) throws PatternObjectException {
        ObserverForge forge;
        Object result = this.createForge(spec, PluggableObjectType.PATTERN_OBSERVER);
        try {
            forge = (ObserverForge)result;
            if (log.isDebugEnabled()) {
                log.debug(".create Successfully instantiated observer");
            }
        }
        catch (ClassCastException e) {
            String message = "Error casting observer factory instance to " + ObserverFactory.class.getName() + " interface for observer '" + spec.getObjectName() + "'";
            throw new PatternObjectException(message, e);
        }
        return forge;
    }

    @Override
    public GuardForge create(PatternGuardSpec spec) throws PatternObjectException {
        GuardForge forge;
        Object result = this.createForge(spec, PluggableObjectType.PATTERN_GUARD);
        try {
            forge = (GuardForge)result;
            if (log.isDebugEnabled()) {
                log.debug(".create Successfully instantiated guard");
            }
        }
        catch (ClassCastException e) {
            String message = "Error casting guard forge instance to " + GuardForge.class.getName() + " interface for guard '" + spec.getObjectName() + "'";
            throw new PatternObjectException(message, e);
        }
        return forge;
    }

    private Object createForge(ObjectSpec spec, PluggableObjectType type) throws PatternObjectException {
        Object result;
        Pair<Class, PluggableObjectEntry> pair;
        if (log.isDebugEnabled()) {
            log.debug(".create Creating factory, spec=" + spec.toString());
        }
        Class forgeClass = null;
        Map<String, Pair<Class, PluggableObjectEntry>> namespaceMap = this.patternObjects.getPluggables().get(spec.getObjectNamespace());
        if (namespaceMap != null && (pair = namespaceMap.get(spec.getObjectName())) != null) {
            if (pair.getSecond().getType() == type) {
                forgeClass = pair.getFirst();
            } else {
                if (type == PluggableObjectType.PATTERN_GUARD) {
                    throw new PatternObjectException("Pattern observer function '" + spec.getObjectName() + "' cannot be used as a pattern guard");
                }
                throw new PatternObjectException("Pattern guard function '" + spec.getObjectName() + "' cannot be used as a pattern observer");
            }
        }
        if (forgeClass == null) {
            String message;
            if (type == PluggableObjectType.PATTERN_GUARD) {
                message = "Pattern guard name '" + spec.getObjectName() + "' is not a known pattern object name";
                throw new PatternObjectException(message);
            }
            if (type == PluggableObjectType.PATTERN_OBSERVER) {
                message = "Pattern observer name '" + spec.getObjectName() + "' is not a known pattern object name";
                throw new PatternObjectException(message);
            }
            throw new PatternObjectException("Pattern object type '" + (Object)((Object)type) + "' not known");
        }
        try {
            result = forgeClass.newInstance();
        }
        catch (IllegalAccessException e) {
            String message = "Error invoking pattern object factory constructor for object '" + spec.getObjectName();
            message = message + "', no invocation access for Class.newInstance";
            throw new PatternObjectException(message, e);
        }
        catch (InstantiationException e) {
            String message = "Error invoking pattern object factory constructor for object '" + spec.getObjectName();
            message = message + "' using Class.newInstance";
            throw new PatternObjectException(message, e);
        }
        return result;
    }
}

