/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.everydistinct;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.compile.stage2.EvalNodeUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodCompute;
import com.espertech.esper.common.internal.epl.pattern.core.EvalFactoryNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalFactoryNodeBase;
import com.espertech.esper.common.internal.epl.pattern.core.EvalFactoryNodeVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertor;
import com.espertech.esper.common.internal.epl.pattern.core.PatternAgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.everydistinct.EvalEveryDistinctNode;

public class EvalEveryDistinctFactoryNode
extends EvalFactoryNodeBase {
    public static final EPTypeClass EPTYPE = new EPTypeClass(EvalEveryDistinctFactoryNode.class);
    private ExprEvaluator distinctExpression;
    private MatchedEventConvertor convertor;
    private TimePeriodCompute timePeriodCompute;
    protected EvalFactoryNode childNode;
    private EPType[] distinctTypes;
    private DataInputOutputSerde distinctSerde;

    public void setDistinctExpression(ExprEvaluator distinctExpression) {
        this.distinctExpression = distinctExpression;
    }

    public void setConvertor(MatchedEventConvertor convertor) {
        this.convertor = convertor;
    }

    public void setTimePeriodCompute(TimePeriodCompute timePeriodCompute) {
        this.timePeriodCompute = timePeriodCompute;
    }

    public void setChildNode(EvalFactoryNode childNode) {
        this.childNode = childNode;
    }

    public void setDistinctTypes(EPType[] distinctTypes) {
        this.distinctTypes = distinctTypes;
    }

    @Override
    public EvalNode makeEvalNode(PatternAgentInstanceContext agentInstanceContext, EvalNode parentNode) {
        EvalNode child = EvalNodeUtil.makeEvalNodeSingleChild(this.childNode, agentInstanceContext, parentNode);
        return new EvalEveryDistinctNode(this, child, agentInstanceContext);
    }

    public ExprEvaluator getDistinctExpression() {
        return this.distinctExpression;
    }

    public MatchedEventConvertor getConvertor() {
        return this.convertor;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return true;
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    public long absExpiry(PatternAgentInstanceContext context) {
        long current = context.getStatementContext().getSchedulingService().getTime();
        return current + this.timePeriodCompute.deltaAdd(current, null, true, context.getAgentInstanceContext());
    }

    public TimePeriodCompute getTimePeriodCompute() {
        return this.timePeriodCompute;
    }

    public EvalFactoryNode getChildNode() {
        return this.childNode;
    }

    public EPType[] getDistinctTypes() {
        return this.distinctTypes;
    }

    public DataInputOutputSerde getDistinctSerde() {
        return this.distinctSerde;
    }

    public void setDistinctSerde(DataInputOutputSerde distinctSerde) {
        this.distinctSerde = distinctSerde;
    }

    @Override
    public void accept(EvalFactoryNodeVisitor visitor) {
        visitor.visit(this);
        this.childNode.accept(visitor);
    }
}

