/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.filter;

import com.espertech.esper.common.internal.epl.pattern.core.EvalNodeBase;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNode;
import com.espertech.esper.common.internal.epl.pattern.core.Evaluator;
import com.espertech.esper.common.internal.epl.pattern.core.PatternAgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.filter.EvalFilterFactoryNode;
import com.espertech.esper.common.internal.epl.pattern.filter.EvalFilterStateNode;
import com.espertech.esper.common.internal.epl.pattern.filter.EvalFilterStateNodeConsumeImpl;
import com.espertech.esper.common.internal.filterspec.FilterAddendumUtil;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalFilterNode
extends EvalNodeBase {
    protected final EvalFilterFactoryNode factoryNode;
    private final FilterValueSetParam[][] addendumFilters;
    private static final Logger log = LoggerFactory.getLogger(EvalFilterNode.class);

    public EvalFilterNode(PatternAgentInstanceContext context, EvalFilterFactoryNode factoryNode) {
        super(context);
        FilterValueSetParam[][] contextPathAddendum;
        this.factoryNode = factoryNode;
        FilterValueSetParam[][] addendum = null;
        if (context.getAgentInstanceContext().getAgentInstanceFilterProxy() != null) {
            addendum = context.getAgentInstanceContext().getAgentInstanceFilterProxy().getAddendumFilters(factoryNode.getFilterSpec(), context.getAgentInstanceContext());
        }
        if ((contextPathAddendum = context.getFilterAddendumForContextPath(factoryNode.getFilterSpec())) != null) {
            addendum = addendum == null ? contextPathAddendum : FilterAddendumUtil.multiplyAddendum(addendum, contextPathAddendum);
        }
        this.addendumFilters = addendum;
    }

    public EvalFilterFactoryNode getFactoryNode() {
        return this.factoryNode;
    }

    public FilterValueSetParam[][] getAddendumFilters() {
        return this.addendumFilters;
    }

    @Override
    public EvalStateNode newState(Evaluator parentNode) {
        if (this.getContext().getConsumptionHandler() != null) {
            return new EvalFilterStateNodeConsumeImpl(parentNode, this);
        }
        return new EvalFilterStateNode(parentNode, this);
    }
}

