/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.followedby;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.compile.stage2.EvalNodeUtil;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleIncidentals;
import com.espertech.esper.common.internal.context.module.StatementReadyCallback;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.pattern.core.EvalFactoryNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalFactoryNodeBase;
import com.espertech.esper.common.internal.epl.pattern.core.EvalFactoryNodeVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.PatternAgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.followedby.EvalFollowedByNode;
import com.espertech.esper.common.internal.epl.pattern.followedby.EvalFollowedByNodeOpType;

public class EvalFollowedByFactoryNode
extends EvalFactoryNodeBase
implements StatementReadyCallback {
    public static final EPTypeClass EPTYPE = new EPTypeClass(EvalFollowedByFactoryNode.class);
    protected EvalFactoryNode[] children;
    private ExprEvaluator[] maxPerChildEvals;
    protected EvalFollowedByNodeOpType opType;

    public void setChildren(EvalFactoryNode[] children) {
        this.children = children;
    }

    public void setMaxPerChildEvals(ExprEvaluator[] maxPerChildEvals) {
        this.maxPerChildEvals = maxPerChildEvals;
        if (maxPerChildEvals != null && maxPerChildEvals.length == 0) {
            throw new IllegalStateException("Invalid empty array");
        }
    }

    @Override
    public void ready(StatementContext statementContext, ModuleIncidentals moduleIncidentals, boolean recovery) {
        boolean hasEngineWidePatternCount;
        boolean hasMax = this.maxPerChildEvals != null;
        boolean bl = hasEngineWidePatternCount = statementContext.getRuntimeSettingsService().getConfigurationRuntime().getPatterns().getMaxSubexpressions() != null;
        this.opType = !hasMax ? (hasEngineWidePatternCount ? EvalFollowedByNodeOpType.NOMAX_POOL : EvalFollowedByNodeOpType.NOMAX_PLAIN) : (hasEngineWidePatternCount ? EvalFollowedByNodeOpType.MAX_POOL : EvalFollowedByNodeOpType.MAX_PLAIN);
    }

    @Override
    public EvalNode makeEvalNode(PatternAgentInstanceContext agentInstanceContext, EvalNode parentNode) {
        EvalNode[] nodes = EvalNodeUtil.makeEvalNodeChildren(this.children, agentInstanceContext, parentNode);
        return new EvalFollowedByNode(agentInstanceContext, this, nodes);
    }

    public EvalFollowedByNodeOpType getOpType() {
        return this.opType;
    }

    public int getMax(int position) {
        ExprEvaluator cachedExpr = this.maxPerChildEvals[position];
        if (cachedExpr == null) {
            return -1;
        }
        Number result = (Number)cachedExpr.evaluate(null, true, null);
        if (result != null) {
            return result.intValue();
        }
        return -1;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    public void accept(EvalFactoryNodeVisitor visitor) {
        visitor.visit(this);
        for (EvalFactoryNode child : this.children) {
            child.accept(visitor);
        }
    }
}

