/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.guard;

import com.espertech.esper.common.client.annotation.AppliesTo;
import com.espertech.esper.common.client.soda.GuardEnum;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage1.spec.PatternGuardSpec;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecTracked;
import com.espertech.esper.common.internal.compile.util.CallbackAttribution;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNodeBase;
import com.espertech.esper.common.internal.epl.pattern.core.PatternExpressionPrecedenceEnum;
import com.espertech.esper.common.internal.epl.pattern.guard.EvalGuardFactoryNode;
import com.espertech.esper.common.internal.epl.pattern.guard.GuardForge;
import com.espertech.esper.common.internal.schedule.ScheduleHandleTracked;
import java.io.StringWriter;
import java.util.List;
import java.util.function.Function;

public class EvalGuardForgeNode
extends EvalForgeNodeBase {
    private PatternGuardSpec patternGuardSpec;
    private GuardForge guardForge;

    public EvalGuardForgeNode(boolean attachPatternText, PatternGuardSpec patternGuardSpec) {
        super(attachPatternText);
        this.patternGuardSpec = patternGuardSpec;
    }

    public PatternGuardSpec getPatternGuardSpec() {
        return this.patternGuardSpec;
    }

    public void setGuardForge(GuardForge guardForge) {
        this.guardForge = guardForge;
    }

    public GuardForge getGuardForge() {
        return this.guardForge;
    }

    public final String toString() {
        return "EvalGuardNode guardForge=" + this.guardForge + "  children=" + this.getChildNodes().size();
    }

    public boolean isFilterChildNonQuitting() {
        return false;
    }

    public boolean isStateful() {
        return true;
    }

    @Override
    protected EPTypeClass typeOfFactory() {
        return EvalGuardFactoryNode.EPTYPE;
    }

    @Override
    protected String nameOfFactory() {
        return "guard";
    }

    @Override
    protected void inlineCodegen(CodegenMethod method, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("node"), "setChildNode", CodegenExpressionBuilder.localMethod(this.getChildNodes().get(0).makeCodegen(method, symbols, classScope), new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setGuardFactory", this.guardForge.makeCodegen(method, symbols, classScope));
    }

    @Override
    public void collectSelfFilterAndSchedule(Function<Short, CallbackAttribution> callbackAttribution, List<FilterSpecTracked> filters, List<ScheduleHandleTracked> schedules) {
        this.guardForge.collectSchedule(this.factoryNodeId, callbackAttribution, schedules);
    }

    public String toPrecedenceFreeEPL() {
        StringWriter writer = new StringWriter();
        this.toPrecedenceFreeEPL(writer);
        return writer.toString();
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        this.getChildNodes().get(0).toEPL(writer, this.getPrecedence());
        if (this.patternGuardSpec.getObjectNamespace().equals(GuardEnum.WHILE_GUARD.getNamespace()) && this.patternGuardSpec.getObjectName().equals(GuardEnum.WHILE_GUARD.getName())) {
            writer.write(" while ");
        } else {
            writer.write(" where ");
            writer.write(this.patternGuardSpec.getObjectNamespace());
            writer.write(":");
            writer.write(this.patternGuardSpec.getObjectName());
        }
        writer.write("(");
        ExprNodeUtilityPrint.toExpressionStringParameterList(this.patternGuardSpec.getObjectParameters(), writer);
        writer.write(")");
    }

    @Override
    public PatternExpressionPrecedenceEnum getPrecedence() {
        return PatternExpressionPrecedenceEnum.GUARD_POSTFIX;
    }

    @Override
    public AppliesTo appliesTo() {
        return AppliesTo.PATTERN_GUARD;
    }
}

