/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.guard;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNodeVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.Evaluator;
import com.espertech.esper.common.internal.epl.pattern.core.PatternAgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.core.PatternConsumptionUtil;
import com.espertech.esper.common.internal.epl.pattern.guard.EvalGuardNode;
import com.espertech.esper.common.internal.epl.pattern.guard.Guard;
import com.espertech.esper.common.internal.epl.pattern.guard.Quitable;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import java.util.Set;

public class EvalGuardStateNode
extends EvalStateNode
implements Evaluator,
Quitable {
    protected EvalGuardNode evalGuardNode;
    protected EvalStateNode activeChildNode;
    protected Guard guard;
    protected MatchedEventMap beginState;

    public EvalGuardStateNode(Evaluator parentNode, EvalGuardNode evalGuardNode) {
        super(parentNode);
        this.evalGuardNode = evalGuardNode;
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        if (PatternConsumptionUtil.containsEvent(matchEvent, this.beginState)) {
            this.quit();
            AgentInstanceContext agentInstanceContext = this.evalGuardNode.getContext().getAgentInstanceContext();
            agentInstanceContext.getAuditProvider().patternFalse(this.evalGuardNode.getFactoryNode(), this, agentInstanceContext);
            this.getParentEvaluator().evaluateFalse(this, true);
        } else if (this.activeChildNode != null) {
            this.activeChildNode.removeMatch(matchEvent);
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalGuardNode;
    }

    @Override
    public PatternAgentInstanceContext getContext() {
        return this.evalGuardNode.getContext();
    }

    @Override
    public void start(MatchedEventMap beginState) {
        AgentInstanceContext agentInstanceContext = this.evalGuardNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternGuardStart(this.evalGuardNode.factoryNode, beginState);
        agentInstanceContext.getAuditProvider().patternInstance(true, this.evalGuardNode.factoryNode, agentInstanceContext);
        this.beginState = beginState;
        this.guard = this.evalGuardNode.getFactoryNode().getGuardFactory().makeGuard(this.evalGuardNode.getContext(), beginState, this, null);
        this.activeChildNode = this.evalGuardNode.getChildNode().newState(this);
        this.activeChildNode.start(beginState);
        this.guard.startGuard();
        agentInstanceContext.getInstrumentationProvider().aPatternGuardStart();
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted, EventBean optionalTriggeringEvent) {
        boolean guardPass;
        boolean haveQuitted;
        AgentInstanceContext agentInstanceContext = this.evalGuardNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternGuardEvaluateTrue(this.evalGuardNode.factoryNode, matchEvent);
        boolean bl = haveQuitted = this.activeChildNode == null;
        if (isQuitted) {
            agentInstanceContext.getAuditProvider().patternInstance(false, this.evalGuardNode.factoryNode, agentInstanceContext);
            this.activeChildNode = null;
            this.guard.stopGuard();
        }
        if (!haveQuitted && (guardPass = this.guard.inspect(matchEvent))) {
            agentInstanceContext.getAuditProvider().patternTrue(this.evalGuardNode.getFactoryNode(), this, matchEvent, isQuitted, agentInstanceContext);
            this.getParentEvaluator().evaluateTrue(matchEvent, this, isQuitted, optionalTriggeringEvent);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternGuardEvaluateTrue(isQuitted);
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        this.activeChildNode = null;
        AgentInstanceContext agentInstanceContext = this.evalGuardNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternGuardEvalFalse(this.evalGuardNode.factoryNode);
        agentInstanceContext.getAuditProvider().patternFalse(this.evalGuardNode.getFactoryNode(), this, agentInstanceContext);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.evalGuardNode.factoryNode, agentInstanceContext);
        this.getParentEvaluator().evaluateFalse(this, true);
        agentInstanceContext.getInstrumentationProvider().aPatternGuardEvalFalse();
    }

    @Override
    public final void quit() {
        if (this.activeChildNode == null) {
            return;
        }
        AgentInstanceContext agentInstanceContext = this.evalGuardNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternGuardQuit(this.evalGuardNode.factoryNode);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.evalGuardNode.factoryNode, agentInstanceContext);
        if (this.activeChildNode != null) {
            this.activeChildNode.quit();
            this.guard.stopGuard();
        }
        this.activeChildNode = null;
        agentInstanceContext.getInstrumentationProvider().aPatternGuardQuit();
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitGuard(this.evalGuardNode.getFactoryNode(), this, this.guard);
        if (this.activeChildNode != null) {
            this.activeChildNode.accept(visitor);
        }
    }

    public final String toString() {
        return "EvaluationWitinStateNode activeChildNode=" + this.activeChildNode + " guard=" + this.guard;
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    @Override
    public void guardQuit() {
        AgentInstanceContext agentInstanceContext = this.evalGuardNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternGuardGuardQuit(this.evalGuardNode.factoryNode);
        if (this.activeChildNode != null) {
            this.activeChildNode.quit();
        }
        this.activeChildNode = null;
        agentInstanceContext.getAuditProvider().patternFalse(this.evalGuardNode.getFactoryNode(), this, agentInstanceContext);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.evalGuardNode.factoryNode, agentInstanceContext);
        this.getParentEvaluator().evaluateFalse(this, true);
        agentInstanceContext.getInstrumentationProvider().aPatternGuardGuardQuit();
    }
}

