/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.guard;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.util.CallbackAttribution;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import com.espertech.esper.common.internal.epl.pattern.core.PatternDeltaComputeUtil;
import com.espertech.esper.common.internal.epl.pattern.guard.GuardForge;
import com.espertech.esper.common.internal.epl.pattern.guard.GuardParameterException;
import com.espertech.esper.common.internal.epl.pattern.guard.TimerWithinGuardFactory;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import com.espertech.esper.common.internal.schedule.ScheduleHandleTracked;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.List;
import java.util.function.Function;

public class TimerWithinGuardForge
implements GuardForge,
ScheduleHandleCallbackProvider {
    private ExprNode timeExpr;
    private MatchedEventConvertorForge convertor;
    private TimeAbacus timeAbacus;
    private int scheduleCallbackId = -1;

    @Override
    public void setScheduleCallbackId(int id) {
        this.scheduleCallbackId = id;
    }

    @Override
    public int getScheduleCallbackId() {
        return this.scheduleCallbackId;
    }

    @Override
    public void setGuardParameters(List<ExprNode> parameters, MatchedEventConvertorForge convertor, StatementCompileTimeServices services) throws GuardParameterException {
        String errorMessage = "Timer-within guard requires a single numeric or time period parameter";
        if (parameters.size() != 1) {
            throw new GuardParameterException(errorMessage);
        }
        if (!JavaClassHelper.isNumeric(parameters.get(0).getForge().getEvaluationType())) {
            throw new GuardParameterException(errorMessage);
        }
        this.convertor = convertor;
        this.timeExpr = parameters.get(0);
        this.timeAbacus = services.getClasspathImportServiceCompileTime().getTimeAbacus();
    }

    @Override
    public void collectSchedule(short factoryNodeId, Function<Short, CallbackAttribution> callbackAttribution, List<ScheduleHandleTracked> schedules) {
        schedules.add(new ScheduleHandleTracked(callbackAttribution.apply(factoryNodeId), this));
    }

    @Override
    public CodegenExpression makeCodegen(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (this.scheduleCallbackId == -1) {
            throw new IllegalStateException("Unassigned schedule callback id");
        }
        CodegenMethod method = parent.makeChild(TimerWithinGuardFactory.EPTYPE, this.getClass(), (CodegenScope)classScope);
        CodegenExpression patternDelta = PatternDeltaComputeUtil.makePatternDeltaAnonymous(this.timeExpr, this.convertor, this.timeAbacus, method, classScope);
        method.getBlock().declareVar(TimerWithinGuardFactory.EPTYPE, "factory", (CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("getPatternFactoryService", new CodegenExpression[0]).add("guardTimerWithin", new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setScheduleCallbackId", CodegenExpressionBuilder.constant(this.scheduleCallbackId)).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setDeltaCompute", patternDelta).methodReturn(CodegenExpressionBuilder.ref("factory"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }
}

