/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.guard;

import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.pattern.guard.EventGuardVisitor;
import com.espertech.esper.common.internal.epl.pattern.guard.Guard;
import com.espertech.esper.common.internal.epl.pattern.guard.Quitable;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;

public class TimerWithinOrMaxCountGuard
implements Guard,
ScheduleHandleCallback {
    public static final String NAME_AUDITPROVIDER_SCHEDULE = "timer-within-max";
    private final long deltaTime;
    private final int numCountTo;
    private final Quitable quitable;
    private final long scheduleSlot;
    private int counter;
    private boolean isTimerActive;
    private EPStatementHandleCallbackSchedule scheduleHandle;

    public TimerWithinOrMaxCountGuard(long deltaTime, int numCountTo, Quitable quitable) {
        this.deltaTime = deltaTime;
        this.numCountTo = numCountTo;
        this.quitable = quitable;
        this.scheduleSlot = quitable.getContext().getAgentInstanceContext().getScheduleBucket().allocateSlot();
    }

    @Override
    public void startGuard() {
        if (this.isTimerActive) {
            throw new IllegalStateException("Timer already active");
        }
        this.scheduleHandle = new EPStatementHandleCallbackSchedule(this.quitable.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle(), this);
        AgentInstanceContext agentInstanceContext = this.quitable.getContext().getAgentInstanceContext();
        agentInstanceContext.getAuditProvider().scheduleAdd(this.deltaTime, agentInstanceContext, this.scheduleHandle, ScheduleObjectType.pattern, NAME_AUDITPROVIDER_SCHEDULE);
        agentInstanceContext.getSchedulingService().add(this.deltaTime, this.scheduleHandle, this.scheduleSlot);
        this.isTimerActive = true;
        this.counter = 0;
    }

    @Override
    public boolean inspect(MatchedEventMap matchEvent) {
        ++this.counter;
        if (this.counter > this.numCountTo) {
            this.quitable.guardQuit();
            this.deactivateTimer();
            return false;
        }
        return true;
    }

    @Override
    public void stopGuard() {
        if (this.isTimerActive) {
            this.deactivateTimer();
        }
    }

    @Override
    public void scheduledTrigger() {
        AgentInstanceContext agentInstanceContext = this.quitable.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternGuardScheduledEval();
        agentInstanceContext.getAuditProvider().scheduleFire(agentInstanceContext, ScheduleObjectType.pattern, NAME_AUDITPROVIDER_SCHEDULE);
        this.isTimerActive = false;
        this.quitable.guardQuit();
        agentInstanceContext.getInstrumentationProvider().aPatternGuardScheduledEval();
    }

    @Override
    public void accept(EventGuardVisitor visitor) {
        visitor.visitGuard(20, this.scheduleSlot);
    }

    private void deactivateTimer() {
        if (this.scheduleHandle != null) {
            AgentInstanceContext agentInstanceContext = this.quitable.getContext().getAgentInstanceContext();
            agentInstanceContext.getAuditProvider().scheduleRemove(agentInstanceContext, this.scheduleHandle, ScheduleObjectType.pattern, NAME_AUDITPROVIDER_SCHEDULE);
            agentInstanceContext.getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
        }
        this.scheduleHandle = null;
        this.isTimerActive = false;
    }
}

