/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.observer;

import com.espertech.esper.common.client.annotation.AppliesTo;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage1.spec.PatternObserverSpec;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecTracked;
import com.espertech.esper.common.internal.compile.util.CallbackAttribution;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNodeBase;
import com.espertech.esper.common.internal.epl.pattern.core.PatternExpressionPrecedenceEnum;
import com.espertech.esper.common.internal.epl.pattern.observer.EvalObserverFactoryNode;
import com.espertech.esper.common.internal.epl.pattern.observer.ObserverForge;
import com.espertech.esper.common.internal.schedule.ScheduleHandleTracked;
import java.io.StringWriter;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalObserverForgeNode
extends EvalForgeNodeBase {
    private static final Logger log = LoggerFactory.getLogger(EvalObserverForgeNode.class);
    private final PatternObserverSpec patternObserverSpec;
    private ObserverForge observerForge;

    public EvalObserverForgeNode(boolean attachPatternText, PatternObserverSpec patternObserverSpec) {
        super(attachPatternText);
        this.patternObserverSpec = patternObserverSpec;
    }

    @Override
    protected EPTypeClass typeOfFactory() {
        return EvalObserverFactoryNode.EPTYPE;
    }

    @Override
    protected String nameOfFactory() {
        return "observer";
    }

    @Override
    protected void inlineCodegen(CodegenMethod method, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("node"), "setObserverFactory", this.observerForge.makeCodegen(method, symbols, classScope));
    }

    public PatternObserverSpec getPatternObserverSpec() {
        return this.patternObserverSpec;
    }

    public void setObserverFactory(ObserverForge observerForge) {
        this.observerForge = observerForge;
    }

    @Override
    public void collectSelfFilterAndSchedule(Function<Short, CallbackAttribution> callbackAttribution, List<FilterSpecTracked> filters, List<ScheduleHandleTracked> schedules) {
        this.observerForge.collectSchedule(this.factoryNodeId, callbackAttribution, schedules);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write(this.patternObserverSpec.getObjectNamespace());
        writer.write(":");
        writer.write(this.patternObserverSpec.getObjectName());
        writer.write("(");
        ExprNodeUtilityPrint.toExpressionStringParameterList(this.patternObserverSpec.getObjectParameters(), writer);
        writer.write(")");
    }

    public String toPrecedenceFreeEPL() {
        StringWriter writer = new StringWriter();
        this.toPrecedenceFreeEPL(writer);
        return writer.toString();
    }

    @Override
    public PatternExpressionPrecedenceEnum getPrecedence() {
        return PatternExpressionPrecedenceEnum.ATOM;
    }

    @Override
    public AppliesTo appliesTo() {
        return AppliesTo.PATTERN_OBSERVER;
    }
}

