/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenInstanceAux;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.collection.ArrayEventIterator;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationService;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.resultset.codegen.ResultSetProcessorCodegenNames;
import com.espertech.esper.common.internal.epl.resultset.order.OrderByProcessor;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessor;
import com.espertech.esper.common.internal.epl.util.EPTypeCollectionConst;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCode;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.view.core.Viewable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class ResultSetProcessorUtil {
    public static final String METHOD_ITERATORTODEQUE = "iteratorToDeque";
    public static final String METHOD_TOPAIRNULLIFALLNULL = "toPairNullIfAllNull";
    public static final String METHOD_APPLYAGGVIEWRESULT = "applyAggViewResult";
    public static final String METHOD_APPLYAGGJOINRESULT = "applyAggJoinResult";
    public static final String METHOD_CLEARANDAGGREGATEUNGROUPED = "clearAndAggregateUngrouped";
    public static final String METHOD_POPULATESELECTJOINEVENTSNOHAVING = "populateSelectJoinEventsNoHaving";
    public static final String METHOD_POPULATESELECTJOINEVENTSNOHAVINGWITHORDERBY = "populateSelectJoinEventsNoHavingWithOrderBy";
    public static final String METHOD_POPULATESELECTEVENTSNOHAVING = "populateSelectEventsNoHaving";
    public static final String METHOD_POPULATESELECTEVENTSNOHAVINGWITHORDERBY = "populateSelectEventsNoHavingWithOrderBy";
    public static final String METHOD_GETSELECTJOINEVENTSNOHAVING = "getSelectJoinEventsNoHaving";
    public static final String METHOD_GETSELECTJOINEVENTSNOHAVINGWITHORDERBY = "getSelectJoinEventsNoHavingWithOrderBy";
    public static final String METHOD_GETSELECTEVENTSNOHAVING = "getSelectEventsNoHaving";
    public static final String METHOD_GETSELECTEVENTSNOHAVINGWITHORDERBY = "getSelectEventsNoHavingWithOrderBy";
    public static final String METHOD_ORDEROUTGOINGGETITERATOR = "orderOutgoingGetIterator";

    public static void evaluateHavingClauseCodegen(ExprForge optionalHavingClause, CodegenClassScope classScope, CodegenInstanceAux instance) {
        Consumer<CodegenMethod> code = method -> {
            if (optionalHavingClause == null) {
                method.getBlock().methodReturn(CodegenExpressionBuilder.constantTrue());
            } else {
                method.getBlock().apply(InstrumentationCode.instblock(classScope, "qHavingClause", ExprForgeCodegenNames.REF_EPS)).declareVar(EPTypePremade.BOOLEANBOXED.getEPType(), "passed", CodegenLegoMethodExpression.codegenBooleanExpressionReturnTrueFalse(optionalHavingClause, classScope, method, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)).apply(InstrumentationCode.instblock(classScope, "aHavingClause", CodegenExpressionBuilder.ref("passed"))).methodReturn(CodegenExpressionBuilder.ref("passed"));
            }
        };
        instance.getMethods().addMethod(EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "evaluateHavingClause", CodegenNamedParam.from(EventBean.EPTYPEARRAY, "eventsPerStream", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isNewData", ExprEvaluatorContext.EPTYPE, "exprEvalCtx"), ResultSetProcessorUtil.class, classScope, code);
    }

    public static void applyAggViewResult(AggregationService aggregationService, ExprEvaluatorContext exprEvaluatorContext, EventBean[] newData, EventBean[] oldData, EventBean[] eventsPerStream) {
        int i;
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                aggregationService.applyEnter(eventsPerStream, null, exprEvaluatorContext);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                aggregationService.applyLeave(eventsPerStream, null, exprEvaluatorContext);
            }
        }
    }

    public static void applyAggJoinResult(AggregationService aggregationService, ExprEvaluatorContext exprEvaluatorContext, Set<MultiKeyArrayOfKeys<EventBean>> newEvents, Set<MultiKeyArrayOfKeys<EventBean>> oldEvents) {
        if (newEvents != null) {
            for (MultiKeyArrayOfKeys<EventBean> events : newEvents) {
                aggregationService.applyEnter(events.getArray(), null, exprEvaluatorContext);
            }
        }
        if (oldEvents != null) {
            for (MultiKeyArrayOfKeys<EventBean> events : oldEvents) {
                aggregationService.applyLeave(events.getArray(), null, exprEvaluatorContext);
            }
        }
    }

    public static EventBean[] getSelectEventsNoHaving(SelectExprProcessor exprProcessor, EventBean[] events, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return null;
        }
        EventBean[] result = new EventBean[events.length];
        EventBean[] eventsPerStream = new EventBean[1];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            result[i] = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
        }
        return result;
    }

    public static EventBean[] getSelectEventsNoHavingWithOrderBy(AggregationService aggregationService, SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, EventBean[] events, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return null;
        }
        EventBean[] result = new EventBean[events.length];
        EventBean[][] eventGenerators = new EventBean[events.length][];
        EventBean[] eventsPerStream = new EventBean[1];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            result[i] = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            eventGenerators[i] = new EventBean[]{events[i]};
        }
        return orderByProcessor.sortPlain(result, eventGenerators, isNewData, exprEvaluatorContext, aggregationService);
    }

    public static EventBean[] getSelectEventsHavingWithOrderBy(AggregationService aggregationService, SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, EventBean[] events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return null;
        }
        ArrayDeque<EventBean> result = null;
        ArrayDeque<EventBean[]> eventGenerators = null;
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] eventBeanArray = events;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean generated;
            EventBean theEvent;
            eventsPerStream[0] = theEvent = eventBeanArray[i];
            boolean passesHaving = ResultSetProcessorUtil.evaluateHavingClause(havingNode, eventsPerStream, isNewData, exprEvaluatorContext);
            if (!passesHaving || (generated = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            if (result == null) {
                result = new ArrayDeque<EventBean>(events.length);
                eventGenerators = new ArrayDeque<EventBean[]>(events.length);
            }
            result.add(generated);
            eventGenerators.add(new EventBean[]{theEvent});
        }
        if (result != null) {
            return orderByProcessor.sortPlain(CollectionUtil.toArrayEvents(result), CollectionUtil.toArrayEventsArray(eventGenerators), isNewData, exprEvaluatorContext, aggregationService);
        }
        return null;
    }

    public static CodegenMethod getSelectEventsHavingWithOrderByCodegen(CodegenClassScope classScope, CodegenInstanceAux instance) {
        Consumer<CodegenMethod> code = methodNode -> {
            methodNode.getBlock().ifRefNullReturnNull("events").declareVar(EPTypePremade.ARRAYDEQUE.getEPType(), "result", CodegenExpressionBuilder.constantNull()).declareVar(EPTypePremade.ARRAYDEQUE.getEPType(), "eventGenerators", CodegenExpressionBuilder.constantNull()).declareVar(EventBean.EPTYPEARRAY, "eventsPerStream", CodegenExpressionBuilder.newArrayByLength(EventBean.EPTYPE, CodegenExpressionBuilder.constant(1)));
            CodegenBlock forEach = methodNode.getBlock().forEach(EventBean.EPTYPE, "theEvent", CodegenExpressionBuilder.ref("events"));
            forEach.assignArrayElement("eventsPerStream", CodegenExpressionBuilder.constant(0), (CodegenExpression)CodegenExpressionBuilder.ref("theEvent"));
            forEach.ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.localMethod(instance.getMethods().getMethod("evaluateHavingClause"), ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT))).blockContinue();
            forEach.declareVar(EventBean.EPTYPE, "generated", CodegenExpressionBuilder.exprDotMethod(ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRNONMEMBER, "process", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)).ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("generated"))).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("result"))).assignRef("result", CodegenExpressionBuilder.newInstance(EPTypePremade.ARRAYDEQUE.getEPType(), CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("events")))).assignRef("eventGenerators", CodegenExpressionBuilder.newInstance(EPTypePremade.ARRAYDEQUE.getEPType(), CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("events")))).blockEnd().exprDotMethod(CodegenExpressionBuilder.ref("result"), "add", CodegenExpressionBuilder.ref("generated")).declareVar(EventBean.EPTYPEARRAY, "tmp", CodegenExpressionBuilder.newArrayByLength(EventBean.EPTYPE, CodegenExpressionBuilder.constant(0))).assignArrayElement("tmp", CodegenExpressionBuilder.constant(0), (CodegenExpression)CodegenExpressionBuilder.ref("theEvent")).exprDotMethod(CodegenExpressionBuilder.ref("eventGenerators"), "add", CodegenExpressionBuilder.ref("tmp")).blockEnd();
            methodNode.getBlock().ifRefNullReturnNull("result").declareVar(EventBean.EPTYPEARRAY, "arr", CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "toArrayEvents", CodegenExpressionBuilder.ref("result"))).declareVar(EventBean.EPTYPEARRAYARRAY, "gen", CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "toArrayEventsArray", CodegenExpressionBuilder.ref("eventGenerators"))).methodReturn(CodegenExpressionBuilder.exprDotMethod(ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, "sortPlain", CodegenExpressionBuilder.ref("arr"), CodegenExpressionBuilder.ref("gen"), ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT, ResultSetProcessorCodegenNames.MEMBER_AGGREGATIONSVC));
        };
        return instance.getMethods().addMethod(EventBean.EPTYPEARRAY, "getSelectEventsHavingWithOrderBy", CodegenNamedParam.from(AggregationService.EPTYPE, ResultSetProcessorCodegenNames.MEMBER_AGGREGATIONSVC.getRef(), SelectExprProcessor.EPTYPE, "selectExprProcessor", OrderByProcessor.EPTYPE, "orderByProcessor", EventBean.EPTYPEARRAY, "events", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isNewData", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isSynthesize", ExprEvaluatorContext.EPTYPE, "exprEvalCtx"), ResultSetProcessorUtil.class, classScope, code);
    }

    public static EventBean[] getSelectEventsHaving(SelectExprProcessor exprProcessor, EventBean[] events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return null;
        }
        ArrayDeque<EventBean> result = null;
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] eventBeanArray = events;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean generated;
            EventBean theEvent;
            eventsPerStream[0] = theEvent = eventBeanArray[i];
            boolean passesHaving = ResultSetProcessorUtil.evaluateHavingClause(havingNode, eventsPerStream, isNewData, exprEvaluatorContext);
            if (!passesHaving || (generated = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            if (result == null) {
                result = new ArrayDeque<EventBean>(events.length);
            }
            result.add(generated);
        }
        return CollectionUtil.toArrayMayNull(result);
    }

    public static CodegenMethod getSelectEventsHavingCodegen(CodegenClassScope classScope, CodegenInstanceAux instance) {
        Consumer<CodegenMethod> code = methodNode -> {
            methodNode.getBlock().ifRefNullReturnNull("events").declareVar(EPTypePremade.ARRAYDEQUE.getEPType(), "result", CodegenExpressionBuilder.constantNull()).declareVar(EventBean.EPTYPEARRAY, "eventsPerStream", CodegenExpressionBuilder.newArrayByLength(EventBean.EPTYPE, CodegenExpressionBuilder.constant(1)));
            CodegenBlock forEach = methodNode.getBlock().forEach(EventBean.EPTYPE, "theEvent", CodegenExpressionBuilder.ref("events"));
            forEach.assignArrayElement(ExprForgeCodegenNames.REF_EPS, CodegenExpressionBuilder.constant(0), (CodegenExpression)CodegenExpressionBuilder.ref("theEvent"));
            forEach.ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.localMethod(instance.getMethods().getMethod("evaluateHavingClause"), ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT))).blockContinue();
            forEach.declareVar(EventBean.EPTYPE, "generated", CodegenExpressionBuilder.exprDotMethod(ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRNONMEMBER, "process", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)).ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("generated"))).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("result"))).assignRef("result", CodegenExpressionBuilder.newInstance(EPTypePremade.ARRAYDEQUE.getEPType(), CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("events")))).blockEnd().exprDotMethod(CodegenExpressionBuilder.ref("result"), "add", CodegenExpressionBuilder.ref("generated")).blockEnd();
            methodNode.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "toArrayMayNull", CodegenExpressionBuilder.ref("result")));
        };
        return instance.getMethods().addMethod(EventBean.EPTYPEARRAY, "getSelectEventsHaving", CodegenNamedParam.from(SelectExprProcessor.EPTYPE, "selectExprProcessor", EventBean.EPTYPEARRAY, "events", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isNewData", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isSynthesize", ExprEvaluatorContext.EPTYPE, "exprEvalCtx"), ResultSetProcessorUtil.class, classScope, code);
    }

    public static EventBean[] getSelectJoinEventsNoHavingWithOrderBy(AggregationService aggregationService, SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, Set<MultiKeyArrayOfKeys<EventBean>> events, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        EventBean[] result = new EventBean[events.size()];
        EventBean[][] eventGenerators = new EventBean[events.size()][];
        int count = 0;
        for (MultiKeyArrayOfKeys<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            result[count] = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            eventGenerators[count] = eventsPerStream;
            ++count;
        }
        return orderByProcessor.sortPlain(result, eventGenerators, isNewData, exprEvaluatorContext, aggregationService);
    }

    public static EventBean[] getSelectJoinEventsNoHaving(SelectExprProcessor exprProcessor, Set<MultiKeyArrayOfKeys<EventBean>> events, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        EventBean[] result = new EventBean[events.size()];
        int count = 0;
        for (MultiKeyArrayOfKeys<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            result[count] = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            ++count;
        }
        return result;
    }

    public static EventBean[] getSelectJoinEventsHaving(SelectExprProcessor exprProcessor, Set<MultiKeyArrayOfKeys<EventBean>> events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        ArrayDeque<EventBean> result = null;
        for (MultiKeyArrayOfKeys<EventBean> key : events) {
            EventBean resultEvent;
            EventBean[] eventsPerStream = key.getArray();
            boolean passesHaving = ResultSetProcessorUtil.evaluateHavingClause(havingNode, eventsPerStream, isNewData, exprEvaluatorContext);
            if (!passesHaving || (resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            if (result == null) {
                result = new ArrayDeque<EventBean>(events.size());
            }
            result.add(resultEvent);
        }
        return CollectionUtil.toArrayMayNull(result);
    }

    public static CodegenMethod getSelectJoinEventsHavingCodegen(CodegenClassScope classScope, CodegenInstanceAux instance) {
        Consumer<CodegenMethod> code = methodNode -> {
            methodNode.getBlock().ifCondition(CodegenExpressionBuilder.or(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("events")), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("events"), "isEmpty", new CodegenExpression[0]), new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.constantNull()).ifRefNullReturnNull("events").declareVar(EPTypePremade.ARRAYDEQUE.getEPType(), "result", CodegenExpressionBuilder.constantNull());
            CodegenBlock forEach = methodNode.getBlock().forEach(MultiKeyArrayOfKeys.EPTYPE, "key", CodegenExpressionBuilder.ref("events"));
            forEach.declareVar(EventBean.EPTYPEARRAY, "eventsPerStream", CodegenExpressionBuilder.cast(EventBean.EPTYPEARRAY, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("key"), "getArray", new CodegenExpression[0])));
            forEach.ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.localMethod(instance.getMethods().getMethod("evaluateHavingClause"), ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT))).blockContinue();
            forEach.declareVar(EventBean.EPTYPE, "generated", CodegenExpressionBuilder.exprDotMethod(ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRNONMEMBER, "process", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)).ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("generated"))).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("result"))).assignRef("result", CodegenExpressionBuilder.newInstance(EPTypePremade.ARRAYDEQUE.getEPType(), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("events"), "size", new CodegenExpression[0]))).blockEnd().exprDotMethod(CodegenExpressionBuilder.ref("result"), "add", CodegenExpressionBuilder.ref("generated")).blockEnd();
            methodNode.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "toArrayMayNull", CodegenExpressionBuilder.ref("result")));
        };
        return instance.getMethods().addMethod(EventBean.EPTYPEARRAY, "getSelectJoinEventsHaving", CodegenNamedParam.from(SelectExprProcessor.EPTYPE, "selectExprProcessor", EPTypeCollectionConst.EPTYPE_SET_MULTIKEYARRAYOFKEYS_EVENTBEAN, "events", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isNewData", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isSynthesize", ExprEvaluatorContext.EPTYPE, "exprEvalCtx"), ResultSetProcessorUtil.class, classScope, code);
    }

    public static EventBean[] getSelectJoinEventsHavingWithOrderBy(AggregationService aggregationService, SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, Set<MultiKeyArrayOfKeys<EventBean>> events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        ArrayDeque<EventBean> result = null;
        ArrayDeque<EventBean[]> eventGenerators = null;
        for (MultiKeyArrayOfKeys<EventBean> key : events) {
            EventBean resultEvent;
            EventBean[] eventsPerStream = key.getArray();
            boolean passesHaving = ResultSetProcessorUtil.evaluateHavingClause(havingNode, eventsPerStream, isNewData, exprEvaluatorContext);
            if (!passesHaving || (resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            if (result == null) {
                result = new ArrayDeque<EventBean>(events.size());
                eventGenerators = new ArrayDeque<EventBean[]>(events.size());
            }
            result.add(resultEvent);
            eventGenerators.add(eventsPerStream);
        }
        if (result != null) {
            return orderByProcessor.sortPlain(CollectionUtil.toArrayEvents(result), CollectionUtil.toArrayEventsArray(eventGenerators), isNewData, exprEvaluatorContext, aggregationService);
        }
        return null;
    }

    public static CodegenMethod getSelectJoinEventsHavingWithOrderByCodegen(CodegenClassScope classScope, CodegenInstanceAux instance) {
        Consumer<CodegenMethod> code = methodNode -> {
            methodNode.getBlock().ifCondition(CodegenExpressionBuilder.or(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("events")), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("events"), "isEmpty", new CodegenExpression[0]), new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.constantNull()).ifRefNullReturnNull("events").declareVar(EPTypePremade.ARRAYDEQUE.getEPType(), "result", CodegenExpressionBuilder.constantNull()).declareVar(EPTypePremade.ARRAYDEQUE.getEPType(), "eventGenerators", CodegenExpressionBuilder.constantNull());
            CodegenBlock forEach = methodNode.getBlock().forEach(MultiKeyArrayOfKeys.EPTYPE, "key", CodegenExpressionBuilder.ref("events"));
            forEach.declareVar(EventBean.EPTYPEARRAY, "eventsPerStream", CodegenExpressionBuilder.cast(EventBean.EPTYPEARRAY, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("key"), "getArray", new CodegenExpression[0])));
            forEach.ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.localMethod(instance.getMethods().getMethod("evaluateHavingClause"), ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT))).blockContinue();
            forEach.declareVar(EventBean.EPTYPE, "resultEvent", CodegenExpressionBuilder.exprDotMethod(ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRNONMEMBER, "process", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)).ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("resultEvent"))).ifCondition(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("result"))).assignRef("result", CodegenExpressionBuilder.newInstance(EPTypePremade.ARRAYDEQUE.getEPType(), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("events"), "size", new CodegenExpression[0]))).assignRef("eventGenerators", CodegenExpressionBuilder.newInstance(EPTypePremade.ARRAYDEQUE.getEPType(), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("events"), "size", new CodegenExpression[0]))).blockEnd().exprDotMethod(CodegenExpressionBuilder.ref("result"), "add", CodegenExpressionBuilder.ref("resultEvent")).exprDotMethod(CodegenExpressionBuilder.ref("eventGenerators"), "add", CodegenExpressionBuilder.ref("eventsPerStream")).blockEnd();
            methodNode.getBlock().ifRefNullReturnNull("result").declareVar(EventBean.EPTYPEARRAY, "arr", CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "toArrayEvents", CodegenExpressionBuilder.ref("result"))).declareVar(EventBean.EPTYPEARRAYARRAY, "gen", CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "toArrayEventsArray", CodegenExpressionBuilder.ref("eventGenerators"))).methodReturn(CodegenExpressionBuilder.exprDotMethod(ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, "sortPlain", CodegenExpressionBuilder.ref("arr"), CodegenExpressionBuilder.ref("gen"), ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT, ResultSetProcessorCodegenNames.MEMBER_AGGREGATIONSVC));
        };
        return instance.getMethods().addMethod(EventBean.EPTYPEARRAY, "getSelectJoinEventsHavingWithOrderBy", CodegenNamedParam.from(AggregationService.EPTYPE, ResultSetProcessorCodegenNames.MEMBER_AGGREGATIONSVC.getRef(), SelectExprProcessor.EPTYPE, "selectExprProcessor", OrderByProcessor.EPTYPE, "orderByProcessor", EPTypeCollectionConst.EPTYPE_SET_MULTIKEYARRAYOFKEYS_EVENTBEANARRAY, "events", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isNewData", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isSynthesize", ExprEvaluatorContext.EPTYPE, "exprEvalCtx"), ResultSetProcessorUtil.class, classScope, code);
    }

    public static void populateSelectEventsNoHaving(SelectExprProcessor exprProcessor, EventBean[] events, boolean isNewData, boolean isSynthesize, Collection<EventBean> result, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] eventBeanArray = events;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean theEvent;
            eventsPerStream[0] = theEvent = eventBeanArray[i];
            EventBean resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            if (resultEvent == null) continue;
            result.add(resultEvent);
        }
    }

    public static void populateSelectEventsNoHavingWithOrderBy(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, EventBean[] events, boolean isNewData, boolean isSynthesize, Collection<EventBean> result, List<Object> sortKeys, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] eventBeanArray = events;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean theEvent;
            eventsPerStream[0] = theEvent = eventBeanArray[i];
            EventBean resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            if (resultEvent == null) continue;
            result.add(resultEvent);
            sortKeys.add(orderByProcessor.getSortKey(eventsPerStream, isNewData, exprEvaluatorContext));
        }
    }

    public static void populateSelectEventsHaving(SelectExprProcessor exprProcessor, EventBean[] events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, List<EventBean> result, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] eventBeanArray = events;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean resultEvent;
            EventBean theEvent;
            eventsPerStream[0] = theEvent = eventBeanArray[i];
            boolean passesHaving = ResultSetProcessorUtil.evaluateHavingClause(havingNode, eventsPerStream, isNewData, exprEvaluatorContext);
            if (!passesHaving || (resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            result.add(resultEvent);
        }
    }

    public static CodegenMethod populateSelectEventsHavingCodegen(CodegenClassScope classScope, CodegenInstanceAux instance) {
        Consumer<CodegenMethod> code = methodNode -> {
            methodNode.getBlock().ifRefNull("events").blockReturnNoValue().declareVar(EventBean.EPTYPEARRAY, "eventsPerStream", CodegenExpressionBuilder.newArrayByLength(EventBean.EPTYPE, CodegenExpressionBuilder.constant(1)));
            CodegenBlock forEach = methodNode.getBlock().forEach(EventBean.EPTYPE, "theEvent", CodegenExpressionBuilder.ref("events"));
            forEach.assignArrayElement(ExprForgeCodegenNames.REF_EPS, CodegenExpressionBuilder.constant(0), (CodegenExpression)CodegenExpressionBuilder.ref("theEvent"));
            forEach.ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.localMethod(instance.getMethods().getMethod("evaluateHavingClause"), ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT))).blockContinue();
            forEach.declareVar(EventBean.EPTYPE, "resultEvent", CodegenExpressionBuilder.exprDotMethod(ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRNONMEMBER, "process", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)).ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("resultEvent"))).exprDotMethod(CodegenExpressionBuilder.ref("result"), "add", CodegenExpressionBuilder.ref("resultEvent"));
        };
        return instance.getMethods().addMethod(EPTypePremade.VOID.getEPType(), "populateSelectEventsHaving", CodegenNamedParam.from(SelectExprProcessor.EPTYPE, "selectExprProcessor", EventBean.EPTYPEARRAY, "events", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isNewData", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isSynthesize", EPTypePremade.LIST.getEPType(), "result", ExprEvaluatorContext.EPTYPE, "exprEvalCtx"), ResultSetProcessorUtil.class, classScope, code);
    }

    public static void populateSelectEventsHavingWithOrderBy(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, EventBean[] events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, List<EventBean> result, List<Object> optSortKeys, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] eventBeanArray = events;
        int n = eventBeanArray.length;
        for (int i = 0; i < n; ++i) {
            EventBean resultEvent;
            EventBean theEvent;
            eventsPerStream[0] = theEvent = eventBeanArray[i];
            boolean passesHaving = ResultSetProcessorUtil.evaluateHavingClause(havingNode, eventsPerStream, isNewData, exprEvaluatorContext);
            if (!passesHaving || (resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            result.add(resultEvent);
            optSortKeys.add(orderByProcessor.getSortKey(eventsPerStream, isNewData, exprEvaluatorContext));
        }
    }

    public static CodegenMethod populateSelectEventsHavingWithOrderByCodegen(CodegenClassScope classScope, CodegenInstanceAux instance) {
        Consumer<CodegenMethod> code = methodNode -> {
            methodNode.getBlock().ifRefNull("events").blockReturnNoValue().declareVar(EventBean.EPTYPEARRAY, "eventsPerStream", CodegenExpressionBuilder.newArrayByLength(EventBean.EPTYPE, CodegenExpressionBuilder.constant(1)));
            CodegenBlock forEach = methodNode.getBlock().forEach(EventBean.EPTYPE, "theEvent", CodegenExpressionBuilder.ref("events"));
            forEach.assignArrayElement(ExprForgeCodegenNames.REF_EPS, CodegenExpressionBuilder.constant(0), (CodegenExpression)CodegenExpressionBuilder.ref("theEvent"));
            forEach.ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.localMethod(instance.getMethods().getMethod("evaluateHavingClause"), ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT))).blockContinue();
            forEach.declareVar(EventBean.EPTYPE, "resultEvent", CodegenExpressionBuilder.exprDotMethod(ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRNONMEMBER, "process", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)).ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("resultEvent"))).exprDotMethod(CodegenExpressionBuilder.ref("result"), "add", CodegenExpressionBuilder.ref("resultEvent")).exprDotMethod(CodegenExpressionBuilder.ref("optSortKeys"), "add", CodegenExpressionBuilder.exprDotMethod(ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, "getSortKey", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
        };
        return instance.getMethods().addMethod(EPTypePremade.VOID.getEPType(), "populateSelectEventsHavingWithOrderBy", CodegenNamedParam.from(SelectExprProcessor.EPTYPE, "selectExprProcessor", OrderByProcessor.EPTYPE, "orderByProcessor", EventBean.EPTYPEARRAY, "events", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isNewData", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isSynthesize", EPTypePremade.LIST.getEPType(), "result", EPTypePremade.LIST.getEPType(), "optSortKeys", ExprEvaluatorContext.EPTYPE, "exprEvalCtx"), ResultSetProcessorUtil.class, classScope, code);
    }

    public static void populateSelectJoinEventsHaving(SelectExprProcessor exprProcessor, Set<MultiKeyArrayOfKeys<EventBean>> events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, List<EventBean> result, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return;
        }
        for (MultiKeyArrayOfKeys<EventBean> key : events) {
            EventBean resultEvent;
            EventBean[] eventsPerStream = key.getArray();
            boolean passesHaving = ResultSetProcessorUtil.evaluateHavingClause(havingNode, eventsPerStream, isNewData, exprEvaluatorContext);
            if (!passesHaving || (resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            result.add(resultEvent);
        }
    }

    public static CodegenMethod populateSelectJoinEventsHavingCodegen(CodegenClassScope classScope, CodegenInstanceAux instance) {
        Consumer<CodegenMethod> code = methodNode -> {
            methodNode.getBlock().ifRefNull("events").blockReturnNoValue();
            CodegenBlock forEach = methodNode.getBlock().forEach(MultiKeyArrayOfKeys.EPTYPE, "key", CodegenExpressionBuilder.ref("events"));
            forEach.declareVar(EventBean.EPTYPEARRAY, "eventsPerStream", CodegenExpressionBuilder.cast(EventBean.EPTYPEARRAY, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("key"), "getArray", new CodegenExpression[0])));
            forEach.ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.localMethod(instance.getMethods().getMethod("evaluateHavingClause"), ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT))).blockContinue();
            forEach.declareVar(EventBean.EPTYPE, "resultEvent", CodegenExpressionBuilder.exprDotMethod(ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRNONMEMBER, "process", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)).ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("resultEvent"))).exprDotMethod(CodegenExpressionBuilder.ref("result"), "add", CodegenExpressionBuilder.ref("resultEvent"));
        };
        return instance.getMethods().addMethod(EPTypePremade.VOID.getEPType(), "populateSelectJoinEventsHavingCodegen", CodegenNamedParam.from(SelectExprProcessor.EPTYPE, "selectExprProcessor", EPTypeCollectionConst.EPTYPE_SET_MULTIKEYARRAYOFKEYS_EVENTBEAN, "events", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isNewData", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isSynthesize", EPTypePremade.LIST.getEPType(), "result", ExprEvaluatorContext.EPTYPE, "exprEvalCtx"), ResultSetProcessorUtil.class, classScope, code);
    }

    public static void populateSelectJoinEventsHavingWithOrderBy(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, Set<MultiKeyArrayOfKeys<EventBean>> events, ExprEvaluator havingNode, boolean isNewData, boolean isSynthesize, List<EventBean> result, List<Object> sortKeys, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return;
        }
        for (MultiKeyArrayOfKeys<EventBean> key : events) {
            EventBean resultEvent;
            EventBean[] eventsPerStream = key.getArray();
            boolean passesHaving = ResultSetProcessorUtil.evaluateHavingClause(havingNode, eventsPerStream, isNewData, exprEvaluatorContext);
            if (!passesHaving || (resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext)) == null) continue;
            result.add(resultEvent);
            sortKeys.add(orderByProcessor.getSortKey(eventsPerStream, isNewData, exprEvaluatorContext));
        }
    }

    public static CodegenMethod populateSelectJoinEventsHavingWithOrderByCodegen(CodegenClassScope classScope, CodegenInstanceAux instance) {
        Consumer<CodegenMethod> code = methodNode -> {
            methodNode.getBlock().ifRefNull("events").blockReturnNoValue();
            CodegenBlock forEach = methodNode.getBlock().forEach(MultiKeyArrayOfKeys.EPTYPE, "key", CodegenExpressionBuilder.ref("events"));
            forEach.declareVar(EventBean.EPTYPEARRAY, "eventsPerStream", CodegenExpressionBuilder.cast(EventBean.EPTYPEARRAY, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("key"), "getArray", new CodegenExpression[0])));
            forEach.ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.localMethod(instance.getMethods().getMethod("evaluateHavingClause"), ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT))).blockContinue();
            forEach.declareVar(EventBean.EPTYPE, "resultEvent", CodegenExpressionBuilder.exprDotMethod(ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRNONMEMBER, "process", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)).ifCondition(CodegenExpressionBuilder.notEqualsNull(CodegenExpressionBuilder.ref("resultEvent"))).exprDotMethod(CodegenExpressionBuilder.ref("result"), "add", CodegenExpressionBuilder.ref("resultEvent")).exprDotMethod(CodegenExpressionBuilder.ref("sortKeys"), "add", CodegenExpressionBuilder.exprDotMethod(ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, "getSortKey", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
        };
        return instance.getMethods().addMethod(EPTypePremade.VOID.getEPType(), "populateSelectJoinEventsHavingWithOrderBy", CodegenNamedParam.from(SelectExprProcessor.EPTYPE, "selectExprProcessor", OrderByProcessor.EPTYPE, "orderByProcessor", EPTypeCollectionConst.EPTYPE_SET_MULTIKEYARRAYOFKEYS_EVENTBEANARRAY, "events", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isNewData", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isSynthesize", EPTypePremade.LIST.getEPType(), "result", EPTypePremade.LIST.getEPType(), "sortKeys", ExprEvaluatorContext.EPTYPE, "exprEvalCtx"), ResultSetProcessorUtil.class, classScope, code);
    }

    public static void populateSelectJoinEventsNoHaving(SelectExprProcessor exprProcessor, Set<MultiKeyArrayOfKeys<EventBean>> events, boolean isNewData, boolean isSynthesize, List<EventBean> result, ExprEvaluatorContext exprEvaluatorContext) {
        int length;
        int n = length = events != null ? events.size() : 0;
        if (length == 0) {
            return;
        }
        for (MultiKeyArrayOfKeys<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            EventBean resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            if (resultEvent == null) continue;
            result.add(resultEvent);
        }
    }

    public static void populateSelectJoinEventsNoHavingWithOrderBy(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, Set<MultiKeyArrayOfKeys<EventBean>> events, boolean isNewData, boolean isSynthesize, List<EventBean> result, List<Object> optSortKeys, ExprEvaluatorContext exprEvaluatorContext) {
        int length;
        int n = length = events != null ? events.size() : 0;
        if (length == 0) {
            return;
        }
        for (MultiKeyArrayOfKeys<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            EventBean resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            if (resultEvent == null) continue;
            result.add(resultEvent);
            optSortKeys.add(orderByProcessor.getSortKey(eventsPerStream, isNewData, exprEvaluatorContext));
        }
    }

    public static void clearAndAggregateUngrouped(ExprEvaluatorContext exprEvaluatorContext, AggregationService aggregationService, Viewable parent) {
        aggregationService.clearResults(exprEvaluatorContext);
        Iterator<EventBean> it = parent.iterator();
        EventBean[] eventsPerStream = new EventBean[1];
        while (it.hasNext()) {
            eventsPerStream[0] = it.next();
            aggregationService.applyEnter(eventsPerStream, null, exprEvaluatorContext);
        }
    }

    public static ArrayDeque<EventBean> iteratorToDeque(Iterator<EventBean> it) {
        ArrayDeque<EventBean> deque = new ArrayDeque<EventBean>();
        while (it.hasNext()) {
            deque.add(it.next());
        }
        return deque;
    }

    public static UniformPair<EventBean[]> toPairNullIfAllNull(EventBean[] selectNewEvents, EventBean[] selectOldEvents) {
        if (selectNewEvents != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    public static void processViewResultCodegen(CodegenMethod method, CodegenClassScope classScope, CodegenInstanceAux instance, boolean hasHaving, boolean selectRStream, boolean hasOrderBy, boolean outputNullIfBothNull) {
        if (!hasHaving) {
            if (selectRStream) {
                if (!hasOrderBy) {
                    method.getBlock().assignRef("selectOldEvents", CodegenExpressionBuilder.staticMethod(ResultSetProcessorUtil.class, METHOD_GETSELECTEVENTSNOHAVING, ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.REF_OLDDATA, CodegenExpressionBuilder.constant(false), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
                } else {
                    method.getBlock().assignRef("selectOldEvents", CodegenExpressionBuilder.staticMethod(ResultSetProcessorUtil.class, METHOD_GETSELECTEVENTSNOHAVINGWITHORDERBY, ResultSetProcessorCodegenNames.MEMBER_AGGREGATIONSVC, ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, ResultSetProcessorCodegenNames.REF_OLDDATA, CodegenExpressionBuilder.constantFalse(), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
                }
            }
            if (!hasOrderBy) {
                method.getBlock().assignRef("selectNewEvents", CodegenExpressionBuilder.staticMethod(ResultSetProcessorUtil.class, METHOD_GETSELECTEVENTSNOHAVING, ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.REF_NEWDATA, CodegenExpressionBuilder.constant(true), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
            } else {
                method.getBlock().assignRef("selectNewEvents", CodegenExpressionBuilder.staticMethod(ResultSetProcessorUtil.class, METHOD_GETSELECTEVENTSNOHAVINGWITHORDERBY, ResultSetProcessorCodegenNames.MEMBER_AGGREGATIONSVC, ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, ResultSetProcessorCodegenNames.REF_NEWDATA, CodegenExpressionBuilder.constantTrue(), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
            }
        } else {
            CodegenMethod select;
            if (selectRStream) {
                if (!hasOrderBy) {
                    select = ResultSetProcessorUtil.getSelectEventsHavingCodegen(classScope, instance);
                    method.getBlock().assignRef("selectOldEvents", (CodegenExpression)CodegenExpressionBuilder.localMethod(select, ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.REF_OLDDATA, CodegenExpressionBuilder.constantFalse(), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
                } else {
                    select = ResultSetProcessorUtil.getSelectEventsHavingWithOrderByCodegen(classScope, instance);
                    method.getBlock().assignRef("selectOldEvents", (CodegenExpression)CodegenExpressionBuilder.localMethod(select, ResultSetProcessorCodegenNames.MEMBER_AGGREGATIONSVC, ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, ResultSetProcessorCodegenNames.REF_OLDDATA, CodegenExpressionBuilder.constantFalse(), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
                }
            }
            if (!hasOrderBy) {
                select = ResultSetProcessorUtil.getSelectEventsHavingCodegen(classScope, instance);
                method.getBlock().assignRef("selectNewEvents", (CodegenExpression)CodegenExpressionBuilder.localMethod(select, ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.REF_NEWDATA, CodegenExpressionBuilder.constantTrue(), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
            } else {
                select = ResultSetProcessorUtil.getSelectEventsHavingWithOrderByCodegen(classScope, instance);
                method.getBlock().assignRef("selectNewEvents", (CodegenExpression)CodegenExpressionBuilder.localMethod(select, ResultSetProcessorCodegenNames.MEMBER_AGGREGATIONSVC, ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, ResultSetProcessorCodegenNames.REF_NEWDATA, CodegenExpressionBuilder.constantTrue(), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
            }
        }
        if (outputNullIfBothNull) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.and(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("selectNewEvents")), CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("selectOldEvents")), new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.constantNull());
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(UniformPair.EPTYPE, CodegenExpressionBuilder.ref("selectNewEvents"), CodegenExpressionBuilder.ref("selectOldEvents")));
    }

    public static void processJoinResultCodegen(CodegenMethod method, CodegenClassScope classScope, CodegenInstanceAux instance, boolean hasHaving, boolean selectRStream, boolean hasOrderBy, boolean outputNullIfBothNull) {
        if (!hasHaving) {
            if (selectRStream) {
                if (!hasOrderBy) {
                    method.getBlock().assignRef("selectOldEvents", CodegenExpressionBuilder.staticMethod(ResultSetProcessorUtil.class, METHOD_GETSELECTJOINEVENTSNOHAVING, ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.REF_OLDDATA, CodegenExpressionBuilder.constantFalse(), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
                } else {
                    method.getBlock().assignRef("selectOldEvents", CodegenExpressionBuilder.staticMethod(ResultSetProcessorUtil.class, METHOD_GETSELECTJOINEVENTSNOHAVINGWITHORDERBY, CodegenExpressionBuilder.constantNull(), ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, ResultSetProcessorCodegenNames.REF_OLDDATA, CodegenExpressionBuilder.constantFalse(), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
                }
            }
            if (!hasOrderBy) {
                method.getBlock().assignRef("selectNewEvents ", CodegenExpressionBuilder.staticMethod(ResultSetProcessorUtil.class, METHOD_GETSELECTJOINEVENTSNOHAVING, ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.REF_NEWDATA, CodegenExpressionBuilder.constantTrue(), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
            } else {
                method.getBlock().assignRef("selectNewEvents ", CodegenExpressionBuilder.staticMethod(ResultSetProcessorUtil.class, METHOD_GETSELECTJOINEVENTSNOHAVINGWITHORDERBY, CodegenExpressionBuilder.constantNull(), ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, ResultSetProcessorCodegenNames.REF_NEWDATA, CodegenExpressionBuilder.constantTrue(), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
            }
        } else {
            CodegenMethod select;
            if (selectRStream) {
                if (!hasOrderBy) {
                    select = ResultSetProcessorUtil.getSelectJoinEventsHavingCodegen(classScope, instance);
                    method.getBlock().assignRef("selectOldEvents", (CodegenExpression)CodegenExpressionBuilder.localMethod(select, ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.REF_OLDDATA, CodegenExpressionBuilder.constantFalse(), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
                } else {
                    select = ResultSetProcessorUtil.getSelectJoinEventsHavingWithOrderByCodegen(classScope, instance);
                    method.getBlock().assignRef("selectOldEvents", (CodegenExpression)CodegenExpressionBuilder.localMethod(select, ResultSetProcessorCodegenNames.MEMBER_AGGREGATIONSVC, ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, ResultSetProcessorCodegenNames.REF_OLDDATA, CodegenExpressionBuilder.constantFalse(), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
                }
            }
            if (!hasOrderBy) {
                select = ResultSetProcessorUtil.getSelectJoinEventsHavingCodegen(classScope, instance);
                method.getBlock().assignRef("selectNewEvents", (CodegenExpression)CodegenExpressionBuilder.localMethod(select, ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.REF_NEWDATA, CodegenExpressionBuilder.constantTrue(), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
            } else {
                select = ResultSetProcessorUtil.getSelectJoinEventsHavingWithOrderByCodegen(classScope, instance);
                method.getBlock().assignRef("selectNewEvents", (CodegenExpression)CodegenExpressionBuilder.localMethod(select, ResultSetProcessorCodegenNames.MEMBER_AGGREGATIONSVC, ResultSetProcessorCodegenNames.MEMBER_SELECTEXPRPROCESSOR, ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, ResultSetProcessorCodegenNames.REF_NEWDATA, CodegenExpressionBuilder.constantTrue(), ResultSetProcessorCodegenNames.REF_ISSYNTHESIZE, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
            }
        }
        if (outputNullIfBothNull) {
            method.getBlock().ifCondition(CodegenExpressionBuilder.and(CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("selectNewEvents")), CodegenExpressionBuilder.equalsNull(CodegenExpressionBuilder.ref("selectOldEvents")), new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.constantNull());
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(UniformPair.EPTYPE, CodegenExpressionBuilder.ref("selectNewEvents"), CodegenExpressionBuilder.ref("selectOldEvents")));
    }

    public static ArrayEventIterator orderOutgoingGetIterator(List<EventBean> outgoingEvents, List<Object> orderKeys, OrderByProcessor orderByProcessor, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean[] outgoingEventsArr = CollectionUtil.toArrayEvents(outgoingEvents);
        Object[] orderKeysArr = CollectionUtil.toArrayObjects(orderKeys);
        EventBean[] orderedEvents = orderByProcessor.sortWOrderKeys(outgoingEventsArr, orderKeysArr, exprEvaluatorContext);
        return new ArrayEventIterator(orderedEvents);
    }

    public static EventBean[] outputFromCountMaySort(int count, EventBean[] events, Object[] keys, EventBean[][] currentGenerators, boolean isNewData, OrderByProcessor orderByProcessor, AgentInstanceContext agentInstanceContext, AggregationService aggregationService) {
        if (count != events.length) {
            if (count == 0) {
                return null;
            }
            events = CollectionUtil.shrinkArrayEvents(count, events);
            if (orderByProcessor != null) {
                keys = CollectionUtil.shrinkArrayObjects(count, keys);
                currentGenerators = CollectionUtil.shrinkArrayEventArray(count, currentGenerators);
            }
        }
        if (orderByProcessor != null) {
            events = orderByProcessor.sortWGroupKeys(events, currentGenerators, keys, isNewData, agentInstanceContext, aggregationService);
        }
        return events;
    }

    public static void outputFromCountMaySortCodegen(CodegenBlock block, CodegenExpressionRef count, CodegenExpressionRef events, CodegenExpressionRef keys, CodegenExpressionRef currentGenerators, boolean hasOrderBy) {
        CodegenBlock resize = block.ifCondition(CodegenExpressionBuilder.not(CodegenExpressionBuilder.equalsIdentity(count, CodegenExpressionBuilder.arrayLength(events))));
        resize.ifCondition(CodegenExpressionBuilder.equalsIdentity(count, CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.constantNull()).assignRef(events.getRef(), CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "shrinkArrayEvents", count, events));
        if (hasOrderBy) {
            resize.assignRef(keys.getRef(), CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "shrinkArrayObjects", count, keys)).assignRef(currentGenerators.getRef(), CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "shrinkArrayEventArray", count, currentGenerators));
        }
        if (hasOrderBy) {
            block.assignRef(events.getRef(), CodegenExpressionBuilder.exprDotMethod(ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, "sortWGroupKeys", events, currentGenerators, keys, ExprForgeCodegenNames.REF_ISNEWDATA, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT, ResultSetProcessorCodegenNames.MEMBER_AGGREGATIONSVC));
        }
        block.methodReturn(events);
    }

    public static UniformPair<EventBean[]> finalizeOutputMaySortMayRStream(List<EventBean> newEvents, List<Object> newEventsSortKey, List<EventBean> oldEvents, List<Object> oldEventsSortKey, boolean selectRStream, OrderByProcessor orderByProcessor, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean[] newEventsArr = CollectionUtil.toArrayNullForEmptyEvents(newEvents);
        EventBean[] oldEventsArr = null;
        if (selectRStream) {
            oldEventsArr = CollectionUtil.toArrayNullForEmptyEvents(oldEvents);
        }
        if (orderByProcessor != null) {
            Object[] sortKeysNew = CollectionUtil.toArrayNullForEmptyObjects(newEventsSortKey);
            newEventsArr = orderByProcessor.sortWOrderKeys(newEventsArr, sortKeysNew, exprEvaluatorContext);
            if (selectRStream) {
                Object[] sortKeysOld = CollectionUtil.toArrayNullForEmptyObjects(oldEventsSortKey);
                oldEventsArr = orderByProcessor.sortWOrderKeys(oldEventsArr, sortKeysOld, exprEvaluatorContext);
            }
        }
        return ResultSetProcessorUtil.toPairNullIfAllNull(newEventsArr, oldEventsArr);
    }

    public static void finalizeOutputMaySortMayRStreamCodegen(CodegenBlock block, CodegenExpressionRef newEvents, CodegenExpressionRef newEventsSortKey, CodegenExpressionRef oldEvents, CodegenExpressionRef oldEventsSortKey, boolean selectRStream, boolean hasOrderBy) {
        block.declareVar(EventBean.EPTYPEARRAY, "newEventsArr", CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "toArrayNullForEmptyEvents", newEvents)).declareVar(EventBean.EPTYPEARRAY, "oldEventsArr", selectRStream ? CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "toArrayNullForEmptyEvents", oldEvents) : CodegenExpressionBuilder.constantNull());
        if (hasOrderBy) {
            block.declareVar(EPTypePremade.OBJECTARRAY.getEPType(), "sortKeysNew", CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "toArrayNullForEmptyObjects", newEventsSortKey)).assignRef("newEventsArr", CodegenExpressionBuilder.exprDotMethod(ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, "sortWOrderKeys", CodegenExpressionBuilder.ref("newEventsArr"), CodegenExpressionBuilder.ref("sortKeysNew"), ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
            if (selectRStream) {
                block.declareVar(EPTypePremade.OBJECTARRAY.getEPType(), "sortKeysOld", CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "toArrayNullForEmptyObjects", oldEventsSortKey)).assignRef("oldEventsArr", CodegenExpressionBuilder.exprDotMethod(ResultSetProcessorCodegenNames.MEMBER_ORDERBYPROCESSOR, "sortWOrderKeys", CodegenExpressionBuilder.ref("oldEventsArr"), CodegenExpressionBuilder.ref("sortKeysOld"), ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT));
            }
        }
        block.returnMethodOrBlock(CodegenExpressionBuilder.staticMethod(ResultSetProcessorUtil.class, METHOD_TOPAIRNULLIFALLNULL, CodegenExpressionBuilder.ref("newEventsArr"), CodegenExpressionBuilder.ref("oldEventsArr")));
    }

    public static void prefixCodegenNewOldEvents(CodegenBlock block, boolean sorting, boolean selectRStream) {
        block.declareVar(EPTypePremade.LIST.getEPType(), "newEvents", CodegenExpressionBuilder.newInstance(EPTypePremade.ARRAYLIST.getEPType(), new CodegenExpression[0])).declareVar(EPTypePremade.LIST.getEPType(), "oldEvents", selectRStream ? CodegenExpressionBuilder.newInstance(EPTypePremade.ARRAYLIST.getEPType(), new CodegenExpression[0]) : CodegenExpressionBuilder.constantNull());
        block.declareVar(EPTypePremade.LIST.getEPType(), "newEventsSortKey", CodegenExpressionBuilder.constantNull()).declareVar(EPTypePremade.LIST.getEPType(), "oldEventsSortKey", CodegenExpressionBuilder.constantNull());
        if (sorting) {
            block.assignRef("newEventsSortKey", CodegenExpressionBuilder.newInstance(EPTypePremade.ARRAYLIST.getEPType(), new CodegenExpression[0])).assignRef("oldEventsSortKey", selectRStream ? CodegenExpressionBuilder.newInstance(EPTypePremade.ARRAYLIST.getEPType(), new CodegenExpression[0]) : CodegenExpressionBuilder.constantNull());
        }
    }

    public static UniformPair<EventBean[]> toPairNullIfAllNullSingle(EventBean istream, EventBean rstream) {
        if (istream != null) {
            EventBean[] eventBeanArray;
            EventBean[] eventBeanArray2 = new EventBean[]{istream};
            if (rstream == null) {
                eventBeanArray = null;
            } else {
                EventBean[] eventBeanArray3 = new EventBean[1];
                eventBeanArray = eventBeanArray3;
                eventBeanArray3[0] = rstream;
            }
            return new UniformPair<Object>(eventBeanArray2, eventBeanArray);
        }
        return rstream == null ? null : new UniformPair<EventBean[]>(null, new EventBean[]{rstream});
    }

    public static UniformPair<EventBean[]> toPairNullIfNullIStream(EventBean istream) {
        return istream == null ? null : new UniformPair<Object>(new EventBean[]{istream}, null);
    }

    public static boolean evaluateHavingClause(ExprEvaluator havingEval, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Boolean pass = (Boolean)havingEval.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        return pass == null ? false : pass;
    }
}

